/*
 * Decompiled with CFR 0.152.
 */
package org.xtext.gradle.tasks.internal;

import java.io.Closeable;
import java.io.File;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collections;
import java.util.Iterator;
import java.util.ServiceLoader;
import java.util.Set;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.xtext.gradle.protocol.IncrementalXtextBuilder;
import org.xtext.gradle.protocol.IncrementalXtextBuilderFactory;
import org.xtext.gradle.tasks.internal.FilteringClassLoader;

public class IncrementalXtextBuilderProvider {
    private static IncrementalXtextBuilder builder;
    private static long builderChecksum;
    private static Object lock;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IncrementalXtextBuilder getBuilder(Set<String> languageSetups, String encoding, Set<File> xtextClasspath) {
        Object object = lock;
        synchronized (object) {
            boolean _incompatibleBuilderExists = IncrementalXtextBuilderProvider.incompatibleBuilderExists(languageSetups, encoding, xtextClasspath);
            if (_incompatibleBuilderExists) {
                IncrementalXtextBuilderProvider.closeBuilder();
            }
            if (builder == null) {
                IncrementalXtextBuilderProvider.createBuilder(languageSetups, encoding, xtextClasspath);
            }
            return builder;
        }
    }

    private static boolean incompatibleBuilderExists(Set<String> languageSetups, String encoding, Set<File> xtextClasspath) {
        long _checkSum;
        boolean _notEquals;
        boolean _and = false;
        _and = builder == null ? false : (_notEquals = (_checkSum = IncrementalXtextBuilderProvider.getCheckSum(languageSetups, encoding, xtextClasspath)) != builderChecksum);
        return _and;
    }

    private static IncrementalXtextBuilder closeBuilder() {
        try {
            IncrementalXtextBuilder _xblockexpression = null;
            Class<?> _class = builder.getClass();
            ClassLoader _classLoader = _class.getClassLoader();
            ((Closeable)((Object)_classLoader)).close();
            builder = null;
            _xblockexpression = null;
            return _xblockexpression;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    private static void createBuilder(Set<String> languageSetups, String encoding, Set<File> xtextClasspath) {
        long _checkSum;
        IncrementalXtextBuilder _get;
        URLClassLoader _builderClassLoader = IncrementalXtextBuilderProvider.getBuilderClassLoader(xtextClasspath);
        ServiceLoader<IncrementalXtextBuilderFactory> loader = ServiceLoader.load(IncrementalXtextBuilderFactory.class, _builderClassLoader);
        Iterator<IncrementalXtextBuilderFactory> providers = loader.iterator();
        boolean _hasNext = providers.hasNext();
        if (!_hasNext) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append((Object)"No ");
            String _name = IncrementalXtextBuilderFactory.class.getName();
            _builder.append((Object)_name, "");
            _builder.append((Object)" found on the classpath");
            throw new IllegalStateException(_builder.toString());
        }
        IncrementalXtextBuilderFactory _next = providers.next();
        builder = _get = _next.get(languageSetups, encoding);
        builderChecksum = _checkSum = IncrementalXtextBuilderProvider.getCheckSum(languageSetups, encoding, xtextClasspath);
    }

    private static URLClassLoader getBuilderClassLoader(Set<File> xtextClasspath) {
        URLClassLoader _xblockexpression = null;
        ClassLoader parent = IncrementalXtextBuilderProvider.class.getClassLoader();
        FilteringClassLoader filtered = new FilteringClassLoader(parent, Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{"org.gradle", "org.apache.log4j", "org.slf4j", "org.xtext.gradle"})));
        Functions.Function1 _function = it -> {
            try {
                URI _uRI = it.toURI();
                return _uRI.toURL();
            }
            catch (Throwable _e) {
                throw Exceptions.sneakyThrow((Throwable)_e);
            }
        };
        Iterable _map = IterableExtensions.map(xtextClasspath, (Functions.Function1)_function);
        _xblockexpression = new URLClassLoader((URL[])Conversions.unwrapArray((Object)_map, URL.class), (ClassLoader)filtered);
        return _xblockexpression;
    }

    private static long getCheckSum(Set<String> languageSetups, String encoding, Set<File> xtextClasspath) {
        long _plus_1;
        long _xblockexpression = 0L;
        long hash = 0L;
        for (String setup : languageSetups) {
            long _plus;
            int _hashCode = setup.hashCode();
            hash = _plus = (long)_hashCode + hash * 31L;
        }
        int _hashCode_1 = encoding.hashCode();
        hash = _plus_1 = (long)_hashCode_1 + hash * 31L;
        for (File classpathEntry : xtextClasspath) {
            long _plus_3;
            String _path = classpathEntry.getPath();
            int _hashCode_2 = _path.hashCode();
            long _lastModified = classpathEntry.lastModified();
            int _hashCode_3 = Long.valueOf(_lastModified).hashCode();
            int _plus_2 = _hashCode_2 + _hashCode_3;
            hash = _plus_3 = (long)_plus_2 + hash * 31L;
        }
        _xblockexpression = hash;
        return _xblockexpression;
    }

    static {
        lock = new Object();
    }
}

