/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.context.internal;

import java.util.Stack;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.context.Execution;
import org.xwiki.context.ExecutionContext;

@Component
@Singleton
public class DefaultExecution
implements Execution {
    private ThreadLocal<Stack<ExecutionContext>> context = new ThreadLocal();

    @Override
    public void pushContext(ExecutionContext context) {
        this.pushContext(context, true);
    }

    @Override
    public void pushContext(ExecutionContext context, boolean inherit) {
        Stack<ExecutionContext> stack = this.context.get();
        if (stack == null) {
            stack = new Stack();
            this.context.set(stack);
        } else if (inherit && !stack.isEmpty()) {
            context.inheritFrom(stack.peek());
        }
        stack.push(context);
    }

    @Override
    public void popContext() {
        this.context.get().pop();
    }

    @Override
    public ExecutionContext getContext() {
        Stack<ExecutionContext> stack = this.context.get();
        return stack == null || stack.isEmpty() ? null : stack.peek();
    }

    @Override
    public void setContext(ExecutionContext context) {
        Stack<ExecutionContext> stack = this.context.get();
        if (stack == null) {
            stack = new Stack();
            this.context.set(stack);
            stack.push(context);
        } else if (stack.isEmpty()) {
            stack.push(context);
        } else {
            if (context != null) {
                context.inheritFrom(stack.peek());
            }
            stack.set(stack.size() - 1, context);
        }
    }

    @Override
    public void removeContext() {
        this.context.remove();
    }
}

