/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.job;

import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.xwiki.job.Request;
import org.xwiki.job.event.status.CancelableJobStatus;
import org.xwiki.job.event.status.JobProgress;
import org.xwiki.job.event.status.JobStatus;
import org.xwiki.job.event.status.QuestionAnsweredEvent;
import org.xwiki.job.event.status.QuestionAskedEvent;
import org.xwiki.job.internal.DefaultJobProgress;
import org.xwiki.logging.LogLevel;
import org.xwiki.logging.LogQueue;
import org.xwiki.logging.LoggerManager;
import org.xwiki.logging.event.LogEvent;
import org.xwiki.logging.event.LoggerListener;
import org.xwiki.logging.tail.LogTail;
import org.xwiki.logging.tail.LoggerTail;
import org.xwiki.observation.EventListener;
import org.xwiki.observation.ObservationManager;
import org.xwiki.observation.WrappedThreadEventListener;
import org.xwiki.observation.event.Event;

public abstract class AbstractJobStatus<R extends Request>
implements JobStatus,
CancelableJobStatus {
    private final transient ObservationManager observationManager;
    private final transient LoggerManager loggerManager;
    private final transient ReentrantLock askLock = new ReentrantLock();
    private final transient Condition answered = this.askLock.newCondition();
    private transient JobStatus parentJobStatus;
    private final DefaultJobProgress progress = new DefaultJobProgress();
    private transient LoggerTail loggerTail;
    private transient LoggerListener logListener;
    private volatile transient Object question;
    private LogQueue logs;
    private String jobType;
    private JobStatus.State state = JobStatus.State.NONE;
    private Throwable error;
    private R request;
    private Date startDate;
    private Date endDate;
    private boolean isolated = true;
    private boolean canceled;
    private boolean cancelable;
    private boolean serialized = true;
    private long questionEnd = -1L;

    @Deprecated
    public AbstractJobStatus(R request, JobStatus parentJobStatus, ObservationManager observationManager, LoggerManager loggerManager) {
        this(null, request, parentJobStatus, observationManager, loggerManager);
    }

    public AbstractJobStatus(String jobType, R request, JobStatus parentJobStatus, ObservationManager observationManager, LoggerManager loggerManager) {
        this.jobType = jobType;
        this.request = request;
        this.parentJobStatus = parentJobStatus;
        this.isolated = parentJobStatus == null;
        this.observationManager = observationManager;
        this.loggerManager = loggerManager;
    }

    public void startListening() {
        this.observationManager.addListener((EventListener)new WrappedThreadEventListener((EventListener)this.progress));
        this.logListener = new LoggerListener(LoggerListener.class.getName() + "_" + this.hashCode(), (org.xwiki.logging.Logger)this.getLoggerTail());
        if (this.isIsolated()) {
            this.loggerManager.pushLogListener((EventListener)this.logListener);
        } else {
            this.observationManager.addListener((EventListener)new WrappedThreadEventListener((EventListener)this.logListener));
        }
    }

    public void ignoreLogs(boolean ignore) {
        this.logListener.setIgnore(ignore);
    }

    public void stopListening() {
        if (this.isIsolated()) {
            this.loggerManager.popLogListener();
        } else {
            this.observationManager.removeListener(this.logListener.getName());
        }
        this.observationManager.removeListener(this.progress.getName());
        this.progress.getRootStep().finish();
        try {
            this.loggerTail.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public String getJobType() {
        return this.jobType;
    }

    @Override
    public JobStatus.State getState() {
        return this.state;
    }

    public void setState(JobStatus.State state) {
        this.state = state;
    }

    @Override
    public Throwable getError() {
        return this.error;
    }

    public void setError(Throwable error) {
        this.error = error;
    }

    public R getRequest() {
        return this.request;
    }

    @Override
    public LogTail getLogTail() {
        return this.getLoggerTail();
    }

    public LoggerTail getLoggerTail() {
        if (this.loggerTail == null) {
            if (this.logs == null) {
                this.logs = new LogQueue();
            }
            this.loggerTail = this.logs;
        }
        return this.loggerTail;
    }

    public void setLoggerTail(LoggerTail loggerTail) {
        this.loggerTail = loggerTail;
        if (this.loggerTail instanceof LogQueue) {
            this.logs = (LogQueue)this.loggerTail;
        }
    }

    @Override
    public JobProgress getProgress() {
        return this.progress;
    }

    @Override
    public void ask(Object question) throws InterruptedException {
        this.ask(question, 0L, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean ask(Object question, long time, TimeUnit unit) throws InterruptedException {
        boolean notTimeout = true;
        this.question = question;
        this.askLock.lockInterruptibly();
        try {
            this.state = JobStatus.State.WAITING;
            if (this.isSubJob()) {
                this.parentJobStatus.ask(question);
            } else {
                String questionType = question != null ? question.getClass().getName() : null;
                QuestionAskedEvent event = new QuestionAskedEvent(questionType, this.request.getId());
                this.observationManager.notify((Event)event, (Object)this);
                if (event.isAnswered()) {
                    this.answered();
                } else if (unit != null) {
                    this.questionEnd = System.nanoTime() + unit.toNanos(time);
                    notTimeout = this.answered.await(time, unit);
                    this.questionEnd = -1L;
                } else {
                    this.answered.await();
                }
            }
            this.state = JobStatus.State.RUNNING;
        }
        finally {
            this.askLock.unlock();
        }
        return notTimeout;
    }

    @Override
    public long getQuestionTimeLeft(TimeUnit unit) {
        return this.questionEnd > -1L ? this.questionEnd - System.nanoTime() : -1L;
    }

    @Override
    public Object getQuestion() {
        return this.question;
    }

    @Override
    public void answered() {
        this.askLock.lock();
        try {
            if (this.isSubJob()) {
                this.question = null;
                this.parentJobStatus.answered();
            } else {
                String questionType = this.question != null ? this.question.getClass().getName() : null;
                this.observationManager.notify((Event)new QuestionAnsweredEvent(questionType, this.request.getId()), (Object)this);
                this.question = null;
                this.answered.signal();
            }
        }
        finally {
            this.askLock.unlock();
        }
    }

    @Override
    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    @Override
    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public boolean isSubJob() {
        return this.getParentJobStatus() != null;
    }

    @Override
    public boolean isIsolated() {
        Boolean isolatedRequest = this.getRequest().isStatusLogIsolated();
        return isolatedRequest != null ? isolatedRequest : this.isolated;
    }

    public void setIsolated(boolean isolated) {
        this.isolated = isolated;
    }

    public JobStatus getParentJobStatus() {
        return this.parentJobStatus;
    }

    public void setParentJobStatus(JobStatus parentJobStatus) {
        this.parentJobStatus = parentJobStatus;
    }

    @Override
    public boolean isCancelable() {
        return this.cancelable;
    }

    public void setCancelable(boolean cancelable) {
        this.cancelable = cancelable;
    }

    @Override
    public void cancel() {
        this.canceled = true;
    }

    @Override
    public boolean isCanceled() {
        return this.canceled;
    }

    @Override
    public boolean isSerialized() {
        Boolean serializdRequest = this.getRequest().isStatusSerialized();
        return serializdRequest != null ? serializdRequest : this.serialized;
    }

    @Override
    @Deprecated
    public LogQueue getLog() {
        LogQueue logQueue = this.logs;
        if (logQueue == null) {
            logQueue = new LogQueue();
            if (this.loggerTail != null) {
                this.loggerTail.log((Logger)logQueue);
            } else {
                this.logs = logQueue;
            }
        }
        return logQueue;
    }

    @Override
    @Deprecated
    public List<LogEvent> getLog(LogLevel level) {
        return this.getLogTail().getLogEvents(level).stream().filter(log -> log.getLevel() == level).collect(Collectors.toList());
    }
}

