/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.properties.internal.converter;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.descriptor.ComponentDescriptor;
import org.xwiki.component.descriptor.DefaultComponentDescriptor;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.component.manager.ComponentRepositoryException;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.component.util.DefaultParameterizedType;
import org.xwiki.observation.AbstractEventListener;
import org.xwiki.observation.event.Event;
import org.xwiki.properties.converter.Converter;
import org.xwiki.properties.internal.converter.ArrayListConverter;
import org.xwiki.properties.internal.converter.HashSetConverter;

@Component
@Named(value="org.xwiki.properties.internal.converter.CollectionConverterRegistratorListener")
@Singleton
public class ConverterRegistratorListener
extends AbstractEventListener
implements Initializable {
    public static final String NAME = "org.xwiki.properties.internal.converter.CollectionConverterRegistratorListener";
    @Inject
    private ComponentManager componentManager;
    @Inject
    private Converter<ArrayList> listConverter;
    @Inject
    private Converter<HashSet> setConverter;
    @Inject
    private Logger logger;

    public ConverterRegistratorListener() {
        super(NAME, new Event[0]);
    }

    public void initialize() throws InitializationException {
        this.registerListConverter(List.of().getClass());
        this.registerListConverter(List.of(Integer.valueOf(1)).getClass());
        this.registerListConverter(List.of(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3)).getClass());
        this.registerListConverter(Arrays.asList(new Object[0]).getClass());
        this.registerListConverter(Collections.emptyList().getClass());
        this.registerListConverter(Collections.unmodifiableList(Collections.emptyList()).getClass());
        this.registerSetConverter(Set.of().getClass());
        this.registerSetConverter(Set.of(Integer.valueOf(1)).getClass());
        this.registerSetConverter(Set.of(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3)).getClass());
        this.registerSetConverter(Collections.emptySet().getClass());
        this.registerSetConverter(Collections.unmodifiableSet(Collections.emptySet()).getClass());
    }

    private void registerListConverter(Class<?> collectionClass) {
        DefaultComponentDescriptor componentDescriptor = new DefaultComponentDescriptor();
        componentDescriptor.setImplementation(ArrayListConverter.class);
        componentDescriptor.setRoleType((Type)new DefaultParameterizedType(null, Converter.class, new Type[]{collectionClass}));
        try {
            this.componentManager.registerComponent((ComponentDescriptor)componentDescriptor, this.listConverter);
        }
        catch (ComponentRepositoryException e) {
            this.logger.error("Failed to register a List converter for type [{}]", collectionClass);
        }
    }

    private void registerSetConverter(Class<?> collectionClass) {
        DefaultComponentDescriptor componentDescriptor = new DefaultComponentDescriptor();
        componentDescriptor.setImplementation(HashSetConverter.class);
        componentDescriptor.setRoleType((Type)new DefaultParameterizedType(null, Converter.class, new Type[]{collectionClass}));
        try {
            this.componentManager.registerComponent((ComponentDescriptor)componentDescriptor, this.setConverter);
        }
        catch (ComponentRepositoryException e) {
            this.logger.error("Failed to register a Set converter for type [{}]", collectionClass);
        }
    }

    public void onEvent(Event event, Object source, Object data) {
    }
}

