/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.block;

import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.BlockFilter;
import org.xwiki.rendering.block.MetaDataBlock;
import org.xwiki.rendering.block.match.BlockMatcher;
import org.xwiki.rendering.block.match.BlockNavigator;
import org.xwiki.rendering.block.match.CounterBlockMatcher;
import org.xwiki.rendering.block.match.FunctionBlockMatcher;
import org.xwiki.rendering.block.match.MetadataBlockMatcher;
import org.xwiki.rendering.listener.Listener;
import org.xwiki.rendering.syntax.Syntax;

public abstract class AbstractBlock
implements Block {
    private Map<String, String> parameters;
    private Map<String, Object> attributes;
    private List<Block> childrenBlocks;
    private Block parentBlock;
    private Block nextSiblingBlock;
    private Block previousSiblingBlock;

    public AbstractBlock() {
    }

    public AbstractBlock(Map<String, String> parameters) {
        this.setParameters(parameters);
    }

    public AbstractBlock(Block childBlock) {
        this(childBlock, Collections.emptyMap());
    }

    public AbstractBlock(List<? extends Block> childrenBlocks) {
        this(childrenBlocks, Collections.emptyMap());
    }

    public AbstractBlock(Block childBlock, Map<String, String> parameters) {
        this(parameters);
        this.addChild(childBlock);
    }

    public AbstractBlock(List<? extends Block> childrenBlocks, Map<String, String> parameters) {
        this(parameters);
        this.addChildren(childrenBlocks);
    }

    private static int indexOfBlock(Block block, List<Block> blocks) {
        int position = 0;
        for (Block child : blocks) {
            if (child == block) {
                return position;
            }
            ++position;
        }
        return -1;
    }

    @Override
    public void addChild(Block blockToAdd) {
        this.insertChildAfter(blockToAdd, null);
    }

    @Override
    public void addChildren(List<? extends Block> blocksToAdd) {
        if (!blocksToAdd.isEmpty()) {
            if (this.childrenBlocks == null) {
                this.childrenBlocks = new ArrayList<Block>(blocksToAdd.size());
            }
            for (Block block : blocksToAdd) {
                this.addChild(block);
            }
        }
    }

    @Override
    public void setChildren(List<? extends Block> children) {
        if (children.isEmpty()) {
            if (this.childrenBlocks != null) {
                this.childrenBlocks.clear();
            }
        } else {
            if (this.childrenBlocks != null) {
                this.childrenBlocks.clear();
            }
            this.addChildren(children);
        }
    }

    @Override
    public void setNextSiblingBlock(Block nextSiblingBlock) {
        this.nextSiblingBlock = nextSiblingBlock;
    }

    @Override
    public void setPreviousSiblingBlock(Block previousSiblingBlock) {
        this.previousSiblingBlock = previousSiblingBlock;
    }

    @Override
    public void insertChildBefore(Block blockToInsert, Block nextBlock) {
        blockToInsert.setParent(this);
        if (nextBlock == null) {
            if (this.childrenBlocks != null && !this.childrenBlocks.isEmpty()) {
                Block lastBlock = this.childrenBlocks.get(this.childrenBlocks.size() - 1);
                blockToInsert.setPreviousSiblingBlock(lastBlock);
                lastBlock.setNextSiblingBlock(blockToInsert);
            } else {
                blockToInsert.setPreviousSiblingBlock(null);
                if (this.childrenBlocks == null) {
                    this.childrenBlocks = new ArrayList<Block>(1);
                }
            }
            blockToInsert.setNextSiblingBlock(null);
            this.childrenBlocks.add(blockToInsert);
        } else {
            Block previousBlock = nextBlock.getPreviousSibling();
            if (previousBlock != null) {
                previousBlock.setNextSiblingBlock(blockToInsert);
                blockToInsert.setPreviousSiblingBlock(previousBlock);
            } else {
                blockToInsert.setPreviousSiblingBlock(null);
            }
            blockToInsert.setNextSiblingBlock(nextBlock);
            nextBlock.setPreviousSiblingBlock(blockToInsert);
            if (this.childrenBlocks == null || this.childrenBlocks.isEmpty()) {
                this.childrenBlocks = new ArrayList<Block>(1);
                this.childrenBlocks.add(blockToInsert);
            } else {
                this.childrenBlocks.add(this.indexOfChild(nextBlock), blockToInsert);
            }
        }
    }

    @Override
    public void insertChildAfter(Block blockToInsert, Block previousBlock) {
        if (previousBlock == null) {
            this.insertChildBefore(blockToInsert, null);
        } else {
            Block nextBlock = previousBlock.getNextSibling();
            if (nextBlock != null) {
                nextBlock.setPreviousSiblingBlock(blockToInsert);
                blockToInsert.setNextSiblingBlock(nextBlock);
            } else {
                blockToInsert.setNextSiblingBlock(null);
            }
            blockToInsert.setPreviousSiblingBlock(previousBlock);
            previousBlock.setNextSiblingBlock(blockToInsert);
            if (this.childrenBlocks == null) {
                this.childrenBlocks = new ArrayList<Block>(1);
            }
            this.childrenBlocks.add(this.indexOfChild(previousBlock) + 1, blockToInsert);
        }
    }

    @Override
    public void replaceChild(Block newBlock, Block oldBlock) {
        this.replaceChild(Collections.singletonList(newBlock), oldBlock);
    }

    @Override
    public void replaceChild(List<Block> newBlocks, Block oldBlock) {
        int position = this.indexOfChild(oldBlock);
        if (position == -1) {
            throw new InvalidParameterException("Provided Block to replace is not a child");
        }
        List<Block> blocks = this.getChildren();
        blocks.remove(position);
        oldBlock.setParent(null);
        Block previousBlock = oldBlock.getPreviousSibling();
        if (newBlocks.isEmpty() && previousBlock != null) {
            previousBlock.setNextSiblingBlock(oldBlock.getNextSibling());
        }
        Block lastBlock = null;
        for (Block block : newBlocks) {
            block.setParent(this);
            block.setPreviousSiblingBlock(previousBlock);
            if (previousBlock != null) {
                previousBlock.setNextSiblingBlock(block);
            }
            previousBlock = block;
            lastBlock = block;
        }
        Block nextBlock = oldBlock.getNextSibling();
        if (nextBlock != null) {
            nextBlock.setPreviousSiblingBlock(lastBlock);
        }
        if (lastBlock != null) {
            lastBlock.setNextSiblingBlock(nextBlock);
        }
        blocks.addAll(position, newBlocks);
        oldBlock.setNextSiblingBlock(null);
        oldBlock.setPreviousSiblingBlock(null);
    }

    private int indexOfChild(Block block) {
        return AbstractBlock.indexOfBlock(block, this.getChildren());
    }

    public long indexOf(Block child) {
        CounterBlockMatcher counter = new CounterBlockMatcher(child);
        Object found = this.getFirstBlock(counter, Block.Axes.DESCENDANT_OR_SELF);
        return found != null ? counter.getCount() : -1L;
    }

    @Override
    public List<Block> getChildren() {
        return this.childrenBlocks == null ? Collections.emptyList() : this.childrenBlocks;
    }

    @Override
    public Block getParent() {
        return this.parentBlock;
    }

    @Override
    public Map<String, String> getParameters() {
        return this.parameters == null ? Collections.emptyMap() : Collections.unmodifiableMap(this.parameters);
    }

    @Override
    public String getParameter(String name) {
        return this.parameters == null ? null : this.parameters.get(name);
    }

    @Override
    public void setParameter(String name, String value) {
        if (this.parameters == null) {
            this.parameters = new LinkedHashMap<String, String>(1);
        }
        this.parameters.put(name, value);
    }

    @Override
    public void setParameters(Map<String, String> parameters) {
        if (this.parameters == null) {
            this.parameters = new LinkedHashMap<String, String>(parameters);
        } else {
            this.parameters.clear();
            this.parameters.putAll(parameters);
        }
    }

    @Override
    public Map<String, Object> getAttributes() {
        return this.attributes == null ? Collections.emptyMap() : Collections.unmodifiableMap(this.attributes);
    }

    @Override
    public Object getAttribute(String name) {
        return this.attributes == null ? null : this.attributes.get(name);
    }

    @Override
    public void setAttribute(String name, Object value) {
        if (this.attributes == null) {
            this.attributes = new LinkedHashMap<String, Object>(1);
        }
        this.attributes.put(name, value);
    }

    @Override
    public void setAttributes(Map<String, Object> attributes) {
        if (this.attributes == null) {
            this.attributes = new LinkedHashMap<String, Object>(attributes);
        } else {
            this.attributes.clear();
            this.attributes.putAll(attributes);
        }
    }

    @Override
    public void setParent(Block parentBlock) {
        this.parentBlock = parentBlock;
    }

    @Override
    public Block getRoot() {
        Block block = this;
        while (block.getParent() != null) {
            block = block.getParent();
        }
        return block;
    }

    @Override
    public Block getNextSibling() {
        return this.nextSiblingBlock;
    }

    @Override
    public Block getPreviousSibling() {
        return this.previousSiblingBlock;
    }

    @Override
    public void removeBlock(Block childBlockToRemove) {
        List<Block> children = this.getChildren();
        int position = AbstractBlock.indexOfBlock(childBlockToRemove, children);
        if (position == -1) {
            throw new InvalidParameterException("Provided Block to remove is not a child");
        }
        this.getChildren().remove(position);
        if (childBlockToRemove != null) {
            Block nextBlock;
            Block previousBlock = childBlockToRemove.getPreviousSibling();
            if (previousBlock != null) {
                previousBlock.setNextSiblingBlock(childBlockToRemove.getNextSibling());
            }
            if ((nextBlock = childBlockToRemove.getNextSibling()) != null) {
                nextBlock.setPreviousSiblingBlock(previousBlock);
            }
            childBlockToRemove.setNextSiblingBlock(null);
            childBlockToRemove.setPreviousSiblingBlock(null);
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Block) {
            EqualsBuilder builder = new EqualsBuilder();
            builder.append(this.getChildren(), ((Block)obj).getChildren());
            builder.append(this.getParameters(), ((Block)obj).getParameters());
            builder.append(this.getAttributes(), ((Block)obj).getAttributes());
            return builder.isEquals();
        }
        return false;
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append(this.childrenBlocks);
        builder.append(this.parameters);
        builder.append(this.attributes);
        return builder.toHashCode();
    }

    @Override
    public Block clone() {
        return this.clone(null);
    }

    @Override
    public Block clone(BlockFilter blockFilter) {
        AbstractBlock block;
        try {
            block = (AbstractBlock)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Failed to clone object", e);
        }
        if (this.parameters != null) {
            block.parameters = new LinkedHashMap<String, String>(this.parameters);
        }
        this.getAttributes().forEach((key, value) -> block.setAttribute((String)key, ObjectUtils.cloneIfPossible((Object)value)));
        if (this.childrenBlocks != null) {
            block.childrenBlocks = new ArrayList<Block>(this.childrenBlocks.size());
            for (Block childBlock : this.childrenBlocks) {
                if (blockFilter != null) {
                    Block clonedChildBlocks = childBlock.clone(blockFilter);
                    List<Block> filteredBlocks = blockFilter.filter(clonedChildBlocks);
                    if (filteredBlocks.isEmpty()) {
                        filteredBlocks = clonedChildBlocks.getChildren();
                    }
                    block.addChildren(filteredBlocks);
                    continue;
                }
                block.addChild(childBlock.clone());
            }
        }
        return block;
    }

    @Override
    public void traverse(Listener listener) {
        this.before(listener);
        for (Block block : this.getChildren()) {
            block.traverse(listener);
        }
        this.after(listener);
    }

    public void before(Listener listener) {
    }

    public void after(Listener listener) {
    }

    @Override
    public <T extends Block> List<T> getBlocks(BlockMatcher matcher, Block.Axes axes) {
        BlockNavigator navigator = new BlockNavigator(matcher);
        return navigator.getBlocks(this, axes);
    }

    @Override
    public <T extends Block> T getFirstBlock(BlockMatcher matcher, Block.Axes axes) {
        BlockNavigator navigator = new BlockNavigator(matcher);
        return navigator.getFirstBlock(this, axes);
    }

    @Override
    public Optional<Syntax> getSyntaxMetadata() {
        MetaDataBlock metaDataBlock = (MetaDataBlock)this.getFirstBlock(MetadataBlockMatcher.SYNTAX, Block.Axes.ANCESTOR_OR_SELF);
        if (metaDataBlock != null) {
            return Optional.ofNullable((Syntax)metaDataBlock.getMetaData().getMetaData("syntax"));
        }
        return Optional.empty();
    }

    @Override
    public <T> Optional<T> get(Function<Block, Optional<T>> searcher, Block.Axes axes) {
        FunctionBlockMatcher<T> matcher = new FunctionBlockMatcher<T>(searcher);
        this.getFirstBlock(matcher, Block.Axes.ANCESTOR_OR_SELF);
        return matcher.getValue();
    }
}

