/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.block;

import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.xwiki.component.util.DefaultParameterizedType;
import org.xwiki.rendering.block.BlockFilter;
import org.xwiki.rendering.block.match.BlockMatcher;
import org.xwiki.rendering.listener.Listener;
import org.xwiki.rendering.syntax.Syntax;
import org.xwiki.stability.Unstable;

public interface Block
extends Cloneable {
    public static final Type LIST_BLOCK_TYPE = new DefaultParameterizedType(null, List.class, new Type[]{Block.class});

    public void traverse(Listener var1);

    public void addChild(Block var1);

    public void addChildren(List<? extends Block> var1);

    public void setChildren(List<? extends Block> var1);

    public void insertChildBefore(Block var1, Block var2);

    public void insertChildAfter(Block var1, Block var2);

    public void replaceChild(Block var1, Block var2);

    public void replaceChild(List<Block> var1, Block var2);

    public Block getParent();

    public void setParent(Block var1);

    public List<Block> getChildren();

    public Block getRoot();

    public void removeBlock(Block var1);

    public Block getNextSibling();

    public void setNextSiblingBlock(Block var1);

    public Block getPreviousSibling();

    public void setPreviousSiblingBlock(Block var1);

    public Block clone(BlockFilter var1);

    public Block clone();

    public Map<String, String> getParameters();

    public String getParameter(String var1);

    public void setParameter(String var1, String var2);

    public void setParameters(Map<String, String> var1);

    @Unstable
    default public Map<String, Object> getAttributes() {
        return Map.of();
    }

    @Unstable
    default public Object getAttribute(String name) {
        return null;
    }

    @Unstable
    public void setAttribute(String var1, Object var2);

    @Unstable
    public void setAttributes(Map<String, Object> var1);

    public <T extends Block> List<T> getBlocks(BlockMatcher var1, Axes var2);

    public <T extends Block> T getFirstBlock(BlockMatcher var1, Axes var2);

    @Unstable
    default public Optional<Syntax> getSyntaxMetadata() {
        return Optional.empty();
    }

    @Unstable
    default public <T> Optional<T> get(Function<Block, Optional<T>> searcher, Axes axes) {
        return Optional.empty();
    }

    public static enum Axes {
        SELF,
        PARENT,
        ANCESTOR,
        ANCESTOR_OR_SELF,
        CHILD,
        DESCENDANT,
        DESCENDANT_OR_SELF,
        FOLLOWING,
        FOLLOWING_SIBLING,
        PRECEDING,
        PRECEDING_SIBLING;

    }
}

