/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.block;

import java.util.Collections;
import java.util.Map;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.xwiki.rendering.block.AbstractBlock;
import org.xwiki.rendering.block.BlockFilter;
import org.xwiki.rendering.listener.Listener;
import org.xwiki.rendering.listener.reference.ResourceReference;

public class ImageBlock
extends AbstractBlock {
    private ResourceReference reference;
    private boolean freestanding;
    private String id;

    public ImageBlock(ResourceReference reference, boolean freestanding) {
        this(reference, freestanding, null, Collections.emptyMap());
    }

    public ImageBlock(ResourceReference reference, boolean freestanding, Map<String, String> parameters) {
        this(reference, freestanding, null, parameters);
    }

    public ImageBlock(ResourceReference reference, boolean freestanding, String id, Map<String, String> parameters) {
        super(parameters);
        this.reference = reference;
        this.freestanding = freestanding;
        this.id = id;
    }

    public ResourceReference getReference() {
        return this.reference;
    }

    public boolean isFreeStandingURI() {
        return this.freestanding;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    @Override
    public void traverse(Listener listener) {
        String idParameter = this.getId();
        if (idParameter == null) {
            listener.onImage(this.getReference(), this.isFreeStandingURI(), this.getParameters());
        } else {
            listener.onImage(this.getReference(), this.isFreeStandingURI(), idParameter, this.getParameters());
        }
    }

    @Override
    public ImageBlock clone(BlockFilter blockFilter) {
        ImageBlock clone = (ImageBlock)super.clone(blockFilter);
        clone.reference = this.getReference().clone();
        clone.freestanding = this.isFreeStandingURI();
        clone.id = this.getId();
        return clone;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ImageBlock that = (ImageBlock)obj;
        return new EqualsBuilder().appendSuper(super.equals(obj)).append((Object)this.getReference(), (Object)that.getReference()).append(this.isFreeStandingURI(), that.isFreeStandingURI()).append((Object)this.getId(), (Object)that.getId()).isEquals();
    }

    @Override
    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.appendSuper(super.hashCode());
        builder.append((Object)this.getReference());
        builder.append(this.isFreeStandingURI());
        builder.append((Object)this.getId());
        return builder.toHashCode();
    }
}

