/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.listener;

import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.rendering.listener.ListenerProvider;
import org.xwiki.rendering.listener.chaining.ChainingListener;
import org.xwiki.rendering.listener.chaining.ListenerChain;
import org.xwiki.rendering.syntax.Syntax;

@Component(roles={ListenerRegistry.class})
@Singleton
public class ListenerRegistry {
    @Inject
    @Named(value="context")
    private Provider<ComponentManager> componentManagerProvider;
    @Inject
    private Logger logger;

    public List<ChainingListener> getListeners(ListenerChain listenerChain, String action, Syntax syntax) {
        try {
            return ((ComponentManager)this.componentManagerProvider.get()).getInstanceList(ListenerProvider.class).stream().filter(listenerProvider -> listenerProvider.accept(action, syntax)).map(listenerProvider -> listenerProvider.getListener(listenerChain)).collect(Collectors.toList());
        }
        catch (ComponentLookupException e) {
            this.logger.warn("Failed to load the list of [{}] for action [{}] and syntax [{}]. Cause [{}].", new Object[]{ListenerProvider.class, action, syntax, ExceptionUtils.getRootCauseMessage((Throwable)e)});
            return List.of();
        }
    }
}

