/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.syntax;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.rendering.parser.ParseException;
import org.xwiki.rendering.syntax.Syntax;
import org.xwiki.rendering.syntax.SyntaxRegistry;
import org.xwiki.rendering.syntax.SyntaxType;

@Component
@Singleton
public class DefaultSyntaxRegistry
implements SyntaxRegistry {
    private static final Pattern SYNTAX_PATTERN = Pattern.compile("(.*)/(.*)");
    private Map<String, Syntax> syntaxes = new HashMap<String, Syntax>();

    @Override
    public void registerSyntaxes(Syntax ... syntaxes) {
        for (Syntax syntax : syntaxes) {
            this.registerSyntax(syntax);
        }
    }

    @Override
    public void unregisterSyntaxes(Syntax ... syntaxes) {
        for (Syntax syntax : syntaxes) {
            this.unregisterSyntax(syntax);
        }
    }

    @Override
    public Map<String, Syntax> getSyntaxes() {
        return Collections.unmodifiableMap(this.syntaxes);
    }

    @Override
    public Optional<Syntax> getSyntax(String syntaxId) {
        return Optional.ofNullable(this.syntaxes.get(syntaxId));
    }

    @Override
    public Syntax resolveSyntax(String syntaxId) throws ParseException {
        return this.getSyntax(syntaxId).orElse(this.valueOf(syntaxId));
    }

    private Syntax valueOf(String syntaxIdAsString) throws ParseException {
        if (syntaxIdAsString == null) {
            throw new ParseException("The passed Syntax cannot be NULL");
        }
        Matcher matcher = SYNTAX_PATTERN.matcher(syntaxIdAsString);
        if (!matcher.matches()) {
            throw new ParseException(String.format("Invalid Syntax format [%s]", syntaxIdAsString));
        }
        String syntaxId = matcher.group(1);
        String version = matcher.group(2);
        SyntaxType syntaxType = SyntaxType.getSyntaxTypes().get(syntaxId);
        if (syntaxType == null) {
            syntaxType = new SyntaxType(syntaxId, syntaxId);
        }
        return new Syntax(syntaxType, version);
    }

    private void registerSyntax(Syntax syntax) {
        this.syntaxes.put(syntax.toIdString(), syntax);
    }

    private void unregisterSyntax(Syntax syntax) {
        this.syntaxes.remove(syntax.toIdString());
    }
}

