/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.transformation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.configuration.RenderingConfiguration;
import org.xwiki.rendering.internal.transformation.MutableRenderingContext;
import org.xwiki.rendering.transformation.RenderingContext;
import org.xwiki.rendering.transformation.Transformation;
import org.xwiki.rendering.transformation.TransformationContext;
import org.xwiki.rendering.transformation.TransformationException;
import org.xwiki.rendering.transformation.TransformationManager;

@Component
@Singleton
public class DefaultTransformationManager
implements TransformationManager {
    @Inject
    protected RenderingConfiguration configuration;
    @Inject
    private RenderingContext renderingContext;
    @Inject
    private Logger logger;
    @Inject
    @Named(value="context")
    private Provider<ComponentManager> componentManagerProvider;

    @Override
    public void performTransformations(Block block, TransformationContext context) throws TransformationException {
        HashMap<String, String> transformationsInError = null;
        for (Transformation transformation : this.getTransformations()) {
            try {
                ((MutableRenderingContext)this.renderingContext).transformInContext(transformation, context, block);
            }
            catch (Exception e) {
                if (transformationsInError == null) {
                    transformationsInError = new HashMap<String, String>();
                }
                transformationsInError.put(transformation.getClass().getName(), ExceptionUtils.getStackTrace((Throwable)e));
            }
        }
        if (transformationsInError != null) {
            StringBuilder builder = new StringBuilder();
            for (Map.Entry entry : transformationsInError.entrySet()) {
                builder.append(String.format("- Transformation: [%s]\n", entry.getKey()));
                builder.append((String)entry.getValue());
            }
            throw new TransformationException(String.format("The following transformations failed to execute properly: [\n%s]", builder.toString()));
        }
    }

    public List<Transformation> getTransformations() {
        return this.getTransformations(this.configuration.getTransformationNames());
    }

    protected List<Transformation> getTransformations(List<String> transformationNames) {
        ArrayList<Transformation> transformations = new ArrayList<Transformation>();
        for (String hint : transformationNames) {
            try {
                transformations.add((Transformation)((ComponentManager)this.componentManagerProvider.get()).getInstance(Transformation.class, hint));
            }
            catch (ComponentLookupException e) {
                this.logger.warn("Failed to locate transformation with hint [{}], ignoring it. Root reason [{}]", (Object)hint, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            }
        }
        Collections.sort(transformations);
        return transformations;
    }
}

