/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.transformation;

import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.function.Supplier;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.context.internal.concurrent.AbstractContextStore;
import org.xwiki.rendering.internal.transformation.MutableRenderingContext;
import org.xwiki.rendering.parser.ParseException;
import org.xwiki.rendering.syntax.Syntax;
import org.xwiki.rendering.syntax.SyntaxRegistry;
import org.xwiki.rendering.transformation.RenderingContext;

@Component
@Singleton
@Named(value="rendering")
public class RenderingContextStore
extends AbstractContextStore {
    public static final String PROP_PREFIX = "rendering.";
    public static final String PROP_DEFAULTSYNTAX = "rendering.defaultsyntax";
    public static final String PROP_TARGETSYNTAX = "rendering.targetsyntax";
    public static final String PROP_RESTRICTED = "rendering.restricted";
    @Inject
    private RenderingContext context;
    @Inject
    private Logger logger;
    @Inject
    private SyntaxRegistry syntaxRegistry;

    public RenderingContextStore() {
        super(new String[]{PROP_DEFAULTSYNTAX, PROP_TARGETSYNTAX, PROP_RESTRICTED});
    }

    public void save(Map<String, Serializable> contextStore, Collection<String> entries) {
        this.save(contextStore, PROP_DEFAULTSYNTAX, this.context::getDefaultSyntax, entries);
        this.save(contextStore, PROP_TARGETSYNTAX, this.context::getTargetSyntax, entries);
        this.save(contextStore, PROP_RESTRICTED, Boolean.valueOf(this.context.isRestricted()), entries);
    }

    private void save(Map<String, Serializable> contextStore, String key, Supplier<Syntax> supplier, Collection<String> entries) {
        Syntax value;
        if (entries.contains(key) && (value = supplier.get()) != null) {
            contextStore.put(key, (Serializable)((Object)value.toIdString()));
        }
    }

    public void restore(Map<String, Serializable> contextStore) {
        MutableRenderingContext mutableContext = (MutableRenderingContext)this.context;
        mutableContext.push(mutableContext.getTransformation(), mutableContext.getXDOM(), this.getSyntax(contextStore, PROP_DEFAULTSYNTAX), null, (Boolean)this.get(contextStore, PROP_RESTRICTED, false), this.getSyntax(contextStore, PROP_TARGETSYNTAX));
    }

    private Syntax getSyntax(Map<String, Serializable> contextStore, String key) {
        Serializable value;
        if (contextStore.containsKey(key) && (value = contextStore.get(key)) != null) {
            try {
                return this.syntaxRegistry.resolveSyntax(value.toString());
            }
            catch (ParseException e) {
                this.logger.warn("Failed to restore the Syntax for key [{}]", (Object)key, (Object)e);
            }
        }
        return null;
    }
}

