/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.parser.xhtml.wikimodel;

import java.util.Collection;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.tuple.Pair;
import org.xwiki.rendering.internal.parser.wikimodel.DefaultXWikiGeneratorListener;
import org.xwiki.rendering.internal.parser.xhtml.wikimodel.XWikiWikiReference;
import org.xwiki.rendering.listener.Listener;
import org.xwiki.rendering.listener.MetaData;
import org.xwiki.rendering.listener.reference.ResourceReference;
import org.xwiki.rendering.listener.reference.ResourceType;
import org.xwiki.rendering.parser.ResourceReferenceParser;
import org.xwiki.rendering.parser.StreamParser;
import org.xwiki.rendering.renderer.PrintRendererFactory;
import org.xwiki.rendering.syntax.Syntax;
import org.xwiki.rendering.util.IdGenerator;
import org.xwiki.rendering.wikimodel.WikiFormat;
import org.xwiki.rendering.wikimodel.WikiParameter;
import org.xwiki.rendering.wikimodel.WikiParameters;
import org.xwiki.rendering.wikimodel.WikiReference;

public class XHTMLXWikiGeneratorListener
extends DefaultXWikiGeneratorListener {
    public static final String METADATA_CONTAINER_CLASS = "xwiki-metadata-container";
    public static final String METADATA_ATTRIBUTE_PREFIX = "data-xwiki-";
    private static final Pattern URL_SCHEME_PATTERN = Pattern.compile("[a-zA-Z0-9+.-]*://");
    private static final String CLASS_ATTRIBUTE = "class";

    public XHTMLXWikiGeneratorListener(StreamParser parser, Listener listener, ResourceReferenceParser linkReferenceParser, ResourceReferenceParser imageReferenceParser, PrintRendererFactory plainRendererFactory, IdGenerator idGenerator, Syntax syntax) {
        super(parser, listener, linkReferenceParser, imageReferenceParser, plainRendererFactory, idGenerator, syntax);
    }

    public void onReference(WikiReference reference) {
        boolean isFreeStanding;
        ResourceReference resourceReference;
        if (!(reference instanceof XWikiWikiReference)) {
            resourceReference = this.computeResourceReference(reference.getLink());
            isFreeStanding = false;
        } else {
            XWikiWikiReference xwikiReference = (XWikiWikiReference)reference;
            resourceReference = xwikiReference.getReference();
            isFreeStanding = xwikiReference.isFreeStanding();
            this.flushFormat();
        }
        Pair parameters = this.convertAndSeparateParameters(reference.getParameters());
        resourceReference.setParameters((Map)parameters.getLeft());
        this.onReference(resourceReference, reference.getLabel(), isFreeStanding, (Map)parameters.getRight(), false);
    }

    public void onImage(WikiReference reference) {
        if (!(reference instanceof XWikiWikiReference)) {
            super.onImage(reference);
        } else {
            XWikiWikiReference xwikiReference = (XWikiWikiReference)reference;
            ResourceReference resourceReference = xwikiReference.getReference();
            this.flushFormat();
            this.onImage(resourceReference, xwikiReference.isFreeStanding(), this.convertParameters(xwikiReference.getParameters()));
        }
    }

    private ResourceReference computeResourceReference(String rawReference) {
        Matcher matcher = URL_SCHEME_PATTERN.matcher(rawReference);
        ResourceReference reference = matcher.lookingAt() ? new ResourceReference(rawReference, ResourceType.URL) : new ResourceReference(rawReference, ResourceType.PATH);
        return reference;
    }

    private boolean isMetaDataElement(WikiParameters parameters) {
        return parameters.getParameter(CLASS_ATTRIBUTE) != null && METADATA_CONTAINER_CLASS.equals(parameters.getParameter(CLASS_ATTRIBUTE).getValue());
    }

    private MetaData createMetaData(WikiParameters parameters) {
        MetaData metaData = new MetaData();
        int prefixSize = METADATA_ATTRIBUTE_PREFIX.length();
        for (WikiParameter parameter : parameters) {
            if (!parameter.getKey().startsWith(METADATA_ATTRIBUTE_PREFIX)) continue;
            String metaDataKey = parameter.getKey().substring(prefixSize);
            metaData.addMetaData(metaDataKey, (Object)parameter.getValue());
        }
        return metaData;
    }

    protected void beginGroup(WikiParameters parameters) {
        if (this.isMetaDataElement(parameters)) {
            this.getListener().beginMetaData(this.createMetaData(parameters));
        } else {
            super.beginGroup(parameters);
        }
    }

    protected void endGroup(WikiParameters parameters) {
        if (this.isMetaDataElement(parameters)) {
            this.getListener().endMetaData(this.createMetaData(parameters));
        } else {
            super.endGroup(parameters);
        }
    }

    public void beginFormat(WikiFormat format) {
        WikiParameters wikiParameters = new WikiParameters((Collection)format.getParams());
        if (this.isMetaDataElement(wikiParameters)) {
            this.getListener().beginMetaData(this.createMetaData(wikiParameters));
        } else {
            super.beginFormat(format);
        }
    }

    public void endFormat(WikiFormat format) {
        WikiParameters wikiParameters = new WikiParameters((Collection)format.getParams());
        if (this.isMetaDataElement(wikiParameters)) {
            this.getListener().endMetaData(this.createMetaData(wikiParameters));
        } else {
            super.endFormat(format);
        }
    }
}

