/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.parser.xhtml;

import java.io.IOException;
import java.io.PushbackReader;
import java.io.Reader;
import java.util.Collections;
import java.util.HashMap;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.rendering.block.XDOM;
import org.xwiki.rendering.internal.parser.wikimodel.AbstractWikiModelParser;
import org.xwiki.rendering.internal.parser.wikimodel.WikiModelStreamParser;
import org.xwiki.rendering.internal.parser.wikimodel.XWikiGeneratorListener;
import org.xwiki.rendering.internal.parser.xhtml.wikimodel.XHTMLXWikiGeneratorListener;
import org.xwiki.rendering.internal.parser.xhtml.wikimodel.XWikiCommentHandler;
import org.xwiki.rendering.internal.parser.xhtml.wikimodel.XWikiDivTagHandler;
import org.xwiki.rendering.internal.parser.xhtml.wikimodel.XWikiHeaderTagHandler;
import org.xwiki.rendering.internal.parser.xhtml.wikimodel.XWikiImageTagHandler;
import org.xwiki.rendering.internal.parser.xhtml.wikimodel.XWikiReferenceTagHandler;
import org.xwiki.rendering.internal.parser.xhtml.wikimodel.XWikiSpanTagHandler;
import org.xwiki.rendering.internal.parser.xhtml.wikimodel.XWikiTableDataTagHandler;
import org.xwiki.rendering.internal.parser.xhtml.wikimodel.XWikiWikiModelHandler;
import org.xwiki.rendering.internal.xhtml.XHTML10SyntaxProvider;
import org.xwiki.rendering.listener.Listener;
import org.xwiki.rendering.parser.ParseException;
import org.xwiki.rendering.parser.ResourceReferenceParser;
import org.xwiki.rendering.parser.StreamParser;
import org.xwiki.rendering.renderer.PrintRendererFactory;
import org.xwiki.rendering.syntax.Syntax;
import org.xwiki.rendering.util.IdGenerator;
import org.xwiki.rendering.wikimodel.IWikiParser;
import org.xwiki.rendering.wikimodel.xhtml.XhtmlParser;
import org.xwiki.rendering.wikimodel.xhtml.handler.CommentHandler;
import org.xwiki.xml.XMLReaderFactory;

@Component
@Named(value="xhtml/1.0")
@Singleton
public class XHTMLParser
extends AbstractWikiModelParser {
    @Inject
    @Named(value="xdom+xml/current")
    private StreamParser xmlParser;
    @Inject
    @Named(value="xdom+xml/current")
    private PrintRendererFactory xmlRenderer;
    @Inject
    @Named(value="link")
    private ResourceReferenceParser linkReferenceParser;
    @Inject
    @Named(value="image")
    private ResourceReferenceParser imageReferenceParser;
    @Inject
    private ComponentManager componentManager;
    @Inject
    @Named(value="xhtmlmarker")
    private ResourceReferenceParser xhtmlMarkerResourceReferenceParser;
    @Inject
    @Named(value="xwiki")
    private XMLReaderFactory xmlReaderFactory;

    public Syntax getSyntax() {
        return XHTML10SyntaxProvider.XHTML_1_0;
    }

    public StreamParser getLinkLabelParser() {
        return this.xmlParser;
    }

    public IWikiParser createWikiModelParser() throws ParseException {
        HashMap<String, XWikiWikiModelHandler> handlers = new HashMap<String, XWikiWikiModelHandler>();
        XWikiHeaderTagHandler handler = new XWikiHeaderTagHandler();
        handlers.put("h1", handler);
        handlers.put("h2", handler);
        handlers.put("h3", handler);
        handlers.put("h4", handler);
        handlers.put("h5", handler);
        handlers.put("h6", handler);
        handlers.put("a", new XWikiReferenceTagHandler((WikiModelStreamParser)this, this.xmlRenderer));
        handlers.put("img", new XWikiImageTagHandler());
        handlers.put("span", new XWikiSpanTagHandler(this.componentManager, this));
        handlers.put("div", new XWikiDivTagHandler("xwiki-document", this.componentManager, this));
        handlers.put("th", new XWikiTableDataTagHandler());
        XhtmlParser parser = new XhtmlParser();
        parser.setExtraHandlers(handlers);
        parser.setCommentHandler((CommentHandler)new XWikiCommentHandler(this.componentManager, this, this.xmlRenderer, this.xhtmlMarkerResourceReferenceParser));
        try {
            parser.setXmlReader(this.xmlReaderFactory.createXMLReader());
        }
        catch (Exception e) {
            throw new ParseException("Failed to create XML reader", (Throwable)e);
        }
        return parser;
    }

    public ResourceReferenceParser getLinkReferenceParser() {
        return this.linkReferenceParser;
    }

    public ResourceReferenceParser getImageReferenceParser() {
        return this.imageReferenceParser;
    }

    public XWikiGeneratorListener createXWikiGeneratorListener(Listener listener, IdGenerator idGenerator) {
        return new XHTMLXWikiGeneratorListener(this.getLinkLabelParser(), listener, this.getLinkReferenceParser(), this.getImageReferenceParser(), this.plainRendererFactory, idGenerator, this.getSyntax());
    }

    public XDOM parse(Reader source) throws ParseException {
        Reader pushBackReader = this.getPushBackReader(source);
        if (pushBackReader != null) {
            return super.parse(pushBackReader);
        }
        return new XDOM(Collections.emptyList());
    }

    public void parse(Reader source, Listener listener) throws ParseException {
        Reader pushBackReader = this.getPushBackReader(source);
        if (pushBackReader != null) {
            super.parse(pushBackReader, listener);
        }
    }

    protected void parse(Reader source, Listener listener, IdGenerator idGenerator) throws ParseException {
        Reader pushBackReader = this.getPushBackReader(source);
        if (pushBackReader != null) {
            super.parse(pushBackReader, listener, idGenerator);
        }
    }

    private Reader getPushBackReader(Reader source) throws ParseException {
        PushbackReader pushbackReader = new PushbackReader(source);
        try {
            int c = pushbackReader.read();
            if (c == -1) {
                return null;
            }
            pushbackReader.unread(c);
        }
        catch (IOException e) {
            throw new ParseException("Failed to find out if the source to parse is empty or not", (Throwable)e);
        }
        return pushbackReader;
    }
}

