/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.renderer.xhtml;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.xwiki.rendering.internal.renderer.xhtml.image.XHTMLImageRenderer;
import org.xwiki.rendering.internal.renderer.xhtml.link.XHTMLLinkRenderer;
import org.xwiki.rendering.listener.Format;
import org.xwiki.rendering.listener.HeaderLevel;
import org.xwiki.rendering.listener.ListType;
import org.xwiki.rendering.listener.chaining.BlockStateChainingListener;
import org.xwiki.rendering.listener.chaining.EmptyBlockChainingListener;
import org.xwiki.rendering.listener.chaining.ListenerChain;
import org.xwiki.rendering.listener.chaining.MetaDataStateChainingListener;
import org.xwiki.rendering.listener.reference.ResourceReference;
import org.xwiki.rendering.renderer.AbstractChainingPrintRenderer;
import org.xwiki.rendering.renderer.printer.WikiPrinter;
import org.xwiki.rendering.renderer.printer.XHTMLWikiPrinter;
import org.xwiki.rendering.syntax.Syntax;
import org.xwiki.rendering.syntax.SyntaxType;

public class XHTMLChainingRenderer
extends AbstractChainingPrintRenderer {
    public static final String GENERATEDHEADERCLASS = "wikigeneratedheader";
    public static final String GENERATEDIDCLASS = "wikigeneratedid";
    private XHTMLLinkRenderer linkRenderer;
    private XHTMLImageRenderer imageRenderer;
    private XHTMLWikiPrinter xhtmlWikiPrinter;

    public XHTMLChainingRenderer(XHTMLLinkRenderer linkRenderer, XHTMLImageRenderer imageRenderer, ListenerChain listenerChain) {
        this.setListenerChain(listenerChain);
        this.linkRenderer = linkRenderer;
        this.imageRenderer = imageRenderer;
    }

    protected BlockStateChainingListener getBlockState() {
        return (BlockStateChainingListener)this.getListenerChain().getListener(BlockStateChainingListener.class);
    }

    protected EmptyBlockChainingListener getEmptyBlockState() {
        return (EmptyBlockChainingListener)this.getListenerChain().getListener(EmptyBlockChainingListener.class);
    }

    protected MetaDataStateChainingListener getMetaDataState() {
        return (MetaDataStateChainingListener)this.getListenerChain().getListener(MetaDataStateChainingListener.class);
    }

    protected void pushPrinter(WikiPrinter wikiPrinter) {
        super.pushPrinter(wikiPrinter);
        this.getXHTMLWikiPrinter().setWikiPrinter(this.getPrinter());
    }

    protected void popPrinter() {
        super.popPrinter();
        this.getXHTMLWikiPrinter().setWikiPrinter(this.getPrinter());
    }

    protected XHTMLWikiPrinter getXHTMLWikiPrinter() {
        if (this.xhtmlWikiPrinter == null) {
            this.xhtmlWikiPrinter = new XHTMLWikiPrinter(this.getPrinter());
        }
        return this.xhtmlWikiPrinter;
    }

    public void beginGroup(Map<String, String> parameters) {
        LinkedHashMap<String, String> clonedParameters = new LinkedHashMap<String, String>();
        clonedParameters.putAll(parameters);
        this.getXHTMLWikiPrinter().setStandalone();
        this.getXHTMLWikiPrinter().printXMLStartElement("div", clonedParameters);
    }

    public void endGroup(Map<String, String> parameters) {
        this.getXHTMLWikiPrinter().printXMLEndElement("div");
    }

    public void beginFormat(Format format, Map<String, String> parameters) {
        switch (format) {
            case BOLD: {
                this.getXHTMLWikiPrinter().printXMLStartElement("strong");
                break;
            }
            case ITALIC: {
                this.getXHTMLWikiPrinter().printXMLStartElement("em");
                break;
            }
            case STRIKEDOUT: {
                this.getXHTMLWikiPrinter().printXMLStartElement("del");
                break;
            }
            case UNDERLINED: {
                this.getXHTMLWikiPrinter().printXMLStartElement("ins");
                break;
            }
            case SUPERSCRIPT: {
                this.getXHTMLWikiPrinter().printXMLStartElement("sup");
                break;
            }
            case SUBSCRIPT: {
                this.getXHTMLWikiPrinter().printXMLStartElement("sub");
                break;
            }
            case MONOSPACE: {
                this.getXHTMLWikiPrinter().printXMLStartElement("tt");
                break;
            }
            case NONE: {
                break;
            }
        }
        if (!parameters.isEmpty()) {
            this.getXHTMLWikiPrinter().printXMLStartElement("span", parameters);
        }
    }

    public void endFormat(Format format, Map<String, String> parameters) {
        if (!parameters.isEmpty()) {
            this.getXHTMLWikiPrinter().printXMLEndElement("span");
        }
        switch (format) {
            case BOLD: {
                this.getXHTMLWikiPrinter().printXMLEndElement("strong");
                break;
            }
            case ITALIC: {
                this.getXHTMLWikiPrinter().printXMLEndElement("em");
                break;
            }
            case STRIKEDOUT: {
                this.getXHTMLWikiPrinter().printXMLEndElement("del");
                break;
            }
            case UNDERLINED: {
                this.getXHTMLWikiPrinter().printXMLEndElement("ins");
                break;
            }
            case SUPERSCRIPT: {
                this.getXHTMLWikiPrinter().printXMLEndElement("sup");
                break;
            }
            case SUBSCRIPT: {
                this.getXHTMLWikiPrinter().printXMLEndElement("sub");
                break;
            }
            case MONOSPACE: {
                this.getXHTMLWikiPrinter().printXMLEndElement("tt");
                break;
            }
            case NONE: {
                break;
            }
        }
    }

    public void beginParagraph(Map<String, String> parameters) {
        this.getXHTMLWikiPrinter().setStandalone();
        this.getXHTMLWikiPrinter().printXMLStartElement("p", parameters);
    }

    public void endParagraph(Map<String, String> parameters) {
        this.getXHTMLWikiPrinter().printXMLEndElement("p");
    }

    public void onNewLine() {
        this.getXHTMLWikiPrinter().printXMLElement("br");
    }

    public void beginLink(ResourceReference reference, boolean freestanding, Map<String, String> parameters) {
        this.linkRenderer.setXHTMLWikiPrinter(this.getXHTMLWikiPrinter());
        List baseReferences = reference.getBaseReferences();
        if (baseReferences.isEmpty()) {
            reference.addBaseReferences(this.getMetaDataState().getAllMetaData("base"));
        }
        this.linkRenderer.beginLink(reference, freestanding, parameters);
    }

    public void endLink(ResourceReference reference, boolean freestanding, Map<String, String> parameters) {
        this.linkRenderer.setHasLabel(!this.getEmptyBlockState().isCurrentContainerBlockEmpty());
        this.linkRenderer.endLink(reference, freestanding, parameters);
    }

    public void beginHeader(HeaderLevel level, String id, Map<String, String> parameters) {
        LinkedHashMap<String, String> attributes = new LinkedHashMap<String, String>();
        attributes.put("id", id);
        if (!parameters.containsKey("id")) {
            this.addClassValue("class", GENERATEDIDCLASS, attributes);
        }
        attributes.putAll(parameters);
        if (this.getBlockState().isInMacro()) {
            this.addClassValue("class", GENERATEDHEADERCLASS, attributes);
        }
        this.getXHTMLWikiPrinter().setStandalone();
        this.getXHTMLWikiPrinter().printXMLStartElement("h" + level.getAsInt(), attributes);
        this.getXHTMLWikiPrinter().printXMLStartElement("span");
    }

    public void endHeader(HeaderLevel level, String id, Map<String, String> parameters) {
        this.getXHTMLWikiPrinter().printXMLEndElement("span");
        this.getXHTMLWikiPrinter().printXMLEndElement("h" + level.getAsInt());
    }

    public void onWord(String word) {
        this.getXHTMLWikiPrinter().printXML(word);
    }

    public void onSpace() {
        this.getXHTMLWikiPrinter().printSpace();
    }

    public void onSpecialSymbol(char symbol) {
        this.getXHTMLWikiPrinter().printXML(String.valueOf(symbol));
    }

    public void beginList(ListType type, Map<String, String> parameters) {
        if (type == ListType.BULLETED) {
            this.getXHTMLWikiPrinter().printXMLStartElement("ul", parameters);
        } else {
            this.getXHTMLWikiPrinter().printXMLStartElement("ol", parameters);
        }
    }

    public void beginListItem() {
        this.getXHTMLWikiPrinter().setStandalone();
        this.getXHTMLWikiPrinter().printXMLStartElement("li");
    }

    public void beginListItem(Map<String, String> parameters) {
        this.getXHTMLWikiPrinter().printXMLStartElement("li", parameters);
    }

    public void endList(ListType type, Map<String, String> parameters) {
        if (type == ListType.BULLETED) {
            this.getXHTMLWikiPrinter().printXMLEndElement("ul");
        } else {
            this.getXHTMLWikiPrinter().printXMLEndElement("ol");
        }
    }

    public void endListItem() {
        this.getXHTMLWikiPrinter().printXMLEndElement("li");
    }

    public void endListItem(Map<String, String> parameters) {
        this.endListItem();
    }

    public void onId(String name) {
        if (this.getBlockState().isInLine()) {
            this.getXHTMLWikiPrinter().printXMLStartElement("span", (String[][])new String[][]{{"id", name}});
            this.getXHTMLWikiPrinter().printXMLEndElement("span");
        } else {
            this.getXHTMLWikiPrinter().printXMLStartElement("div", (String[][])new String[][]{{"id", name}});
            this.getXHTMLWikiPrinter().printXMLEndElement("div");
        }
    }

    public void onHorizontalLine(Map<String, String> parameters) {
        this.getXHTMLWikiPrinter().printXMLElement("hr", parameters);
    }

    public void onVerbatim(String content, boolean inline, Map<String, String> parameters) {
        if (inline) {
            this.getXHTMLWikiPrinter().printXMLStartElement("tt", (String[][])new String[][]{{"class", "wikimodel-verbatim"}});
            this.getXHTMLWikiPrinter().printXML(content);
            this.getXHTMLWikiPrinter().printXMLEndElement("tt");
        } else {
            this.getXHTMLWikiPrinter().printXMLStartElement("pre", parameters);
            this.getXHTMLWikiPrinter().printXML(content);
            this.getXHTMLWikiPrinter().printXMLEndElement("pre");
        }
    }

    public void onEmptyLines(int count) {
        for (int i = 0; i < count; ++i) {
            this.getXHTMLWikiPrinter().printXMLStartElement("div", (String[][])new String[][]{{"class", "wikimodel-emptyline"}});
            this.getXHTMLWikiPrinter().printXMLEndElement("div");
        }
    }

    public void beginDefinitionList(Map<String, String> parameters) {
        this.getXHTMLWikiPrinter().printXMLStartElement("dl", parameters);
    }

    public void endDefinitionList(Map<String, String> parameters) {
        this.getXHTMLWikiPrinter().printXMLEndElement("dl");
    }

    public void beginDefinitionTerm() {
        this.getXHTMLWikiPrinter().printXMLStartElement("dt");
    }

    public void beginDefinitionDescription() {
        this.getXHTMLWikiPrinter().printXMLStartElement("dd");
    }

    public void endDefinitionTerm() {
        this.getXHTMLWikiPrinter().printXMLEndElement("dt");
    }

    public void endDefinitionDescription() {
        this.getXHTMLWikiPrinter().printXMLEndElement("dd");
    }

    public void beginQuotation(Map<String, String> parameters) {
        if (this.getBlockState().isInQuotationLine()) {
            this.getXHTMLWikiPrinter().printXMLEndElement("p");
        }
        this.getXHTMLWikiPrinter().printXMLStartElement("blockquote", parameters);
        this.getXHTMLWikiPrinter().setStandalone();
        this.getXHTMLWikiPrinter().printXMLStartElement("p");
    }

    public void endQuotation(Map<String, String> parameters) {
        this.getXHTMLWikiPrinter().printXMLEndElement("p");
        this.getXHTMLWikiPrinter().printXMLEndElement("blockquote");
        if (this.getBlockState().isInQuotationLine()) {
            this.getXHTMLWikiPrinter().printXMLStartElement("p");
        }
    }

    public void beginQuotationLine() {
        if (this.getBlockState().isInQuotation() && this.getBlockState().getPreviousEvent() == BlockStateChainingListener.Event.QUOTATION_LINE) {
            this.onNewLine();
        }
    }

    public void beginTable(Map<String, String> parameters) {
        this.getXHTMLWikiPrinter().printXMLStartElement("table", parameters);
    }

    public void beginTableRow(Map<String, String> parameters) {
        this.getXHTMLWikiPrinter().printXMLStartElement("tr", parameters);
    }

    public void beginTableCell(Map<String, String> parameters) {
        this.getXHTMLWikiPrinter().setStandalone();
        this.getXHTMLWikiPrinter().printXMLStartElement("td", parameters);
    }

    public void beginTableHeadCell(Map<String, String> parameters) {
        Map<String, String> parametersWithScope;
        this.getXHTMLWikiPrinter().setStandalone();
        if (!parameters.containsKey("scope")) {
            parametersWithScope = new LinkedHashMap<String, String>(parameters);
            if (this.getBlockState().getCellRow() == 0 || this.getBlockState().getCellCol() > 0) {
                parametersWithScope.put("scope", "col");
            } else {
                parametersWithScope.put("scope", "row");
            }
        } else {
            parametersWithScope = parameters;
        }
        this.getXHTMLWikiPrinter().printXMLStartElement("th", parametersWithScope);
    }

    public void endTable(Map<String, String> parameters) {
        this.getXHTMLWikiPrinter().printXMLEndElement("table");
    }

    public void endTableRow(Map<String, String> parameters) {
        this.getXHTMLWikiPrinter().printXMLEndElement("tr");
    }

    public void endTableCell(Map<String, String> parameters) {
        this.getXHTMLWikiPrinter().printXMLEndElement("td");
    }

    public void endTableHeadCell(Map<String, String> parameters) {
        this.getXHTMLWikiPrinter().printXMLEndElement("th");
    }

    public void onImage(ResourceReference reference, boolean freestanding, Map<String, String> parameters) {
        this.imageRenderer.setXHTMLWikiPrinter(this.getXHTMLWikiPrinter());
        List baseReferences = reference.getBaseReferences();
        if (baseReferences.isEmpty()) {
            reference.addBaseReferences(this.getMetaDataState().getAllMetaData("base"));
        }
        this.imageRenderer.onImage(reference, freestanding, parameters);
    }

    public void onRawText(String text, Syntax syntax) {
        if (SyntaxType.HTML_FAMILY_TYPES.contains(syntax.getType())) {
            this.getXHTMLWikiPrinter().printRaw(text);
        }
    }

    public void beginFigureCaption(Map<String, String> parameters) {
        this.getXHTMLWikiPrinter().printXMLStartElement("p", parameters);
    }

    public void endFigureCaption(Map<String, String> parameters) {
        this.getXHTMLWikiPrinter().printXMLEndElement("p");
    }

    private void addClassValue(String classAttributeName, String newClassValue, Map<String, String> attributes) {
        String classValue = attributes.get(classAttributeName);
        classValue = classValue == null ? newClassValue : classValue.trim() + " " + newClassValue;
        attributes.put(classAttributeName, classValue);
    }
}

