/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.parser.xhtml.wikimodel;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Map;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.rendering.block.XDOM;
import org.xwiki.rendering.internal.parser.XDOMGeneratorListener;
import org.xwiki.rendering.internal.parser.wikimodel.XWikiGeneratorListener;
import org.xwiki.rendering.internal.parser.xhtml.XHTMLParser;
import org.xwiki.rendering.internal.parser.xhtml.wikimodel.XWikiWikiModelHandler;
import org.xwiki.rendering.internal.parser.xhtml.wikimodel.XWikiWikiReference;
import org.xwiki.rendering.listener.Listener;
import org.xwiki.rendering.listener.MetaData;
import org.xwiki.rendering.listener.reference.ResourceReference;
import org.xwiki.rendering.parser.ResourceReferenceParser;
import org.xwiki.rendering.renderer.reference.link.URILabelGenerator;
import org.xwiki.rendering.wikimodel.WikiParameter;
import org.xwiki.rendering.wikimodel.WikiParameters;
import org.xwiki.rendering.wikimodel.WikiReference;
import org.xwiki.rendering.wikimodel.xhtml.handler.CommentHandler;
import org.xwiki.rendering.wikimodel.xhtml.handler.TagHandler;
import org.xwiki.rendering.wikimodel.xhtml.impl.IgnoreElementRule;
import org.xwiki.rendering.wikimodel.xhtml.impl.MacroInfo;
import org.xwiki.rendering.wikimodel.xhtml.impl.TagContext;
import org.xwiki.rendering.wikimodel.xhtml.impl.TagStack;
import org.xwiki.xml.XMLUtils;

public class XWikiCommentHandler
extends CommentHandler
implements XWikiWikiModelHandler {
    private XHTMLParser parser;
    private ComponentManager componentManager;
    private ResourceReferenceParser xhtmlMarkerResourceReferenceParser;
    private Deque<String> commentContentStack = new ArrayDeque<String>();

    public XWikiCommentHandler(ComponentManager componentManager, XHTMLParser parser, ResourceReferenceParser xhtmlMarkerResourceReferenceParser) {
        this.componentManager = componentManager;
        this.parser = parser;
        this.xhtmlMarkerResourceReferenceParser = xhtmlMarkerResourceReferenceParser;
    }

    public void onComment(String content, TagStack stack) {
        boolean ignoreElements = stack.shouldIgnoreElements();
        if (!ignoreElements && content.startsWith("startwikilink:")) {
            this.handleLinkCommentStart(XMLUtils.unescapeXMLComment((String)content), stack);
        } else if (!ignoreElements && content.startsWith("stopwikilink")) {
            this.handleLinkCommentStop(stack);
        } else if (!ignoreElements && content.startsWith("startimage:")) {
            this.handleImageCommentStart(XMLUtils.unescapeXMLComment((String)content), stack);
        } else if (!ignoreElements && content.startsWith("stopimage")) {
            this.handleImageCommentStop(stack);
        } else if (content.startsWith("startmacro:")) {
            this.handleMacroCommentStart(XMLUtils.unescapeXMLComment((String)content), stack);
        } else if (content.startsWith("stopmacro")) {
            this.handleMacroCommentStop(stack);
        } else {
            super.onComment(content, stack);
        }
    }

    private void handleMacroCommentStart(String content, TagStack stack) {
        boolean shouldIgnoreAll = stack.shouldIgnoreElements();
        MacroInfo macroInfo = new MacroInfo(content);
        stack.pushStackParameter("macroInfo", (Object)macroInfo);
        if (shouldIgnoreAll) {
            stack.setIgnoreElements();
        } else {
            stack.pushIgnoreElementRule(new IgnoreElementRule(ignoreElementRule -> {
                boolean result = false;
                TagContext tagContext = ignoreElementRule.getTagContext();
                boolean beginElement = ignoreElementRule.isBeginElement();
                boolean isCurrentlyActive = ignoreElementRule.isActive();
                WikiParameters wikiParameters = tagContext.getParams();
                Map ruleContext = ignoreElementRule.getRuleContext();
                int divCounter = 0;
                if (ruleContext.containsKey("non-generated-content")) {
                    divCounter = (Integer)ruleContext.get("non-generated-content");
                }
                if (wikiParameters != null) {
                    boolean onNotGeneratedContentDiv;
                    boolean bl = onNotGeneratedContentDiv = wikiParameters.getParameter("data-xwiki-non-generated-content") != null;
                    if (onNotGeneratedContentDiv) {
                        if (beginElement) {
                            if (isCurrentlyActive && divCounter == 0) {
                                result = true;
                            } else {
                                ++divCounter;
                            }
                        } else if (!isCurrentlyActive && divCounter == 0) {
                            result = true;
                        } else {
                            --divCounter;
                        }
                    }
                }
                ruleContext.put("non-generated-content", divCounter);
                return result;
            }, true));
        }
    }

    private void handleMacroCommentStop(TagStack stack) {
        if (stack.getStackParameter("macroInfo") != null) {
            MacroInfo macroInfo = (MacroInfo)stack.popStackParameter("macroInfo");
            IgnoreElementRule ignoreElementRule = stack.popIgnoreElementRule();
            if (!ignoreElementRule.equals(TagStack.IGNORE_ALL)) {
                if (stack.isInsideBlockElement()) {
                    stack.getScannerContext().onMacroInline(macroInfo.getName(), macroInfo.getParameters(), macroInfo.getContent());
                } else {
                    TagHandler.sendEmptyLines((TagStack)stack);
                    stack.getScannerContext().onMacroBlock(macroInfo.getName(), macroInfo.getParameters(), macroInfo.getContent());
                }
            }
        }
    }

    private void handleLinkCommentStart(String content, TagStack stack) {
        XDOMGeneratorListener linkLabelListener = new XDOMGeneratorListener();
        linkLabelListener.beginDocument(MetaData.EMPTY);
        XWikiGeneratorListener xwikiListener = this.parser.createXWikiGeneratorListener((Listener)linkLabelListener, null);
        stack.pushStackParameter("linkListener", (Object)xwikiListener);
        stack.pushStackParameter("isInLink", (Object)Boolean.TRUE);
        stack.pushStackParameter("isFreeStandingLink", (Object)Boolean.FALSE);
        stack.pushStackParameter("linkParameters", (Object)WikiParameters.EMPTY);
        this.commentContentStack.push(content.substring("startwikilink:".length()));
    }

    private void handleLinkCommentStop(TagStack stack) {
        XWikiGeneratorListener xwikiListener = (XWikiGeneratorListener)stack.popStackParameter("linkListener");
        XDOMGeneratorListener linkLabelRenderer = (XDOMGeneratorListener)xwikiListener.getListener();
        linkLabelRenderer.endDocument(MetaData.EMPTY);
        boolean isFreeStandingLink = (Boolean)stack.getStackParameter("isFreeStandingLink");
        ResourceReference linkReference = this.xhtmlMarkerResourceReferenceParser.parse(this.commentContentStack.pop());
        WikiParameters linkParams = WikiParameters.EMPTY;
        XDOM label = null;
        if (!isFreeStandingLink) {
            label = linkLabelRenderer.getXDOM();
            linkParams = (WikiParameters)stack.getStackParameter("linkParameters");
        }
        XWikiWikiReference wikiReference = new XWikiWikiReference(linkReference, label, linkParams, isFreeStandingLink);
        stack.getScannerContext().onReference((WikiReference)wikiReference);
        stack.popStackParameter("isInLink");
        stack.popStackParameter("isFreeStandingLink");
        stack.popStackParameter("linkParameters");
    }

    private void handleImageCommentStart(String content, TagStack stack) {
        stack.setStackParameter("isInImage", (Object)Boolean.TRUE);
        this.commentContentStack.push(content.substring("startimage:".length()));
    }

    private void handleImageCommentStop(TagStack stack) {
        WikiParameter alt;
        boolean isFreeStandingImage = (Boolean)stack.getStackParameter("isFreeStandingImage");
        ResourceReference imageReference = this.xhtmlMarkerResourceReferenceParser.parse(this.commentContentStack.pop());
        WikiParameters imageParams = WikiParameters.EMPTY;
        if (!isFreeStandingImage && (alt = (imageParams = (WikiParameters)stack.getStackParameter("imageParameters")).getParameter("alt")) != null && alt.getValue().equals(this.computeAltAttributeValue(imageReference))) {
            imageParams = imageParams.remove("alt");
        }
        XWikiWikiReference reference = new XWikiWikiReference(imageReference, null, imageParams, isFreeStandingImage);
        stack.getScannerContext().onImage((WikiReference)reference);
        stack.setStackParameter("isInImage", (Object)Boolean.FALSE);
        stack.setStackParameter("isFreeStandingImage", (Object)Boolean.FALSE);
        stack.setStackParameter("imageParameters", (Object)WikiParameters.EMPTY);
    }

    private String computeAltAttributeValue(ResourceReference reference) {
        String label;
        try {
            URILabelGenerator uriLabelGenerator = (URILabelGenerator)this.componentManager.getInstance(URILabelGenerator.class, reference.getType().getScheme());
            label = uriLabelGenerator.generateLabel(reference);
        }
        catch (ComponentLookupException e) {
            label = reference.getReference();
        }
        return label;
    }
}

