/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.parser.xwiki20.wikimodel;

import java.io.Reader;
import java.io.StringReader;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.rendering.internal.parser.wikimodel.DefaultXWikiGeneratorListener;
import org.xwiki.rendering.listener.Listener;
import org.xwiki.rendering.listener.MetaData;
import org.xwiki.rendering.listener.QueueListener;
import org.xwiki.rendering.listener.WrappingListener;
import org.xwiki.rendering.listener.chaining.EventType;
import org.xwiki.rendering.parser.ParseException;
import org.xwiki.rendering.parser.ResourceReferenceParser;
import org.xwiki.rendering.parser.StreamParser;
import org.xwiki.rendering.renderer.PrintRendererFactory;
import org.xwiki.rendering.syntax.Syntax;
import org.xwiki.rendering.util.IdGenerator;
import org.xwiki.rendering.wikimodel.WikiParameters;
import org.xwiki.rendering.wikimodel.WikiReference;

public class XWiki20XWikiGeneratorListener
extends DefaultXWikiGeneratorListener {
    private static final String CLASS_PARAMETER = "class";
    private static final String IMAGE_CLASS = "image";
    private static final String IMAGE_LABEL_PARAMETER = "data-xwiki-image-label";
    private final StreamParser imageLabelParser;

    public XWiki20XWikiGeneratorListener(StreamParser parser, Listener listener, ResourceReferenceParser linkReferenceParser, ResourceReferenceParser imageReferenceParser, PrintRendererFactory plainRendererFactory, IdGenerator idGenerator, Syntax syntax) {
        super(parser, listener, linkReferenceParser, imageReferenceParser, plainRendererFactory, idGenerator, syntax);
        this.imageLabelParser = parser;
    }

    public void onImage(WikiReference reference) {
        LinkedHashMap<String, String> parameters = this.convertParameters(reference.getParameters());
        String label = reference.getLabel();
        if (label != null) {
            if (parameters.isEmpty()) {
                parameters = new LinkedHashMap<String, String>();
            }
            parameters.put(IMAGE_LABEL_PARAMETER, label);
        }
        this.onImage(reference.getLink(), false, parameters);
    }

    public void beginParagraph(WikiParameters params) {
        this.pushListener((Listener)new QueueListener());
    }

    public void endParagraph(WikiParameters params) {
        this.flushFormat();
        QueueListener queue = (QueueListener)this.getListener();
        this.popListener();
        Map paragraphParameters = this.convertParameters(params);
        QueueListener.Event imageEvent = null;
        if (queue.size() == 1 && ((QueueListener.Event)queue.getFirst()).eventType == EventType.ON_IMAGE) {
            imageEvent = (QueueListener.Event)queue.getFirst();
        } else if (XWiki20XWikiGeneratorListener.isLinkWrappedImage(queue)) {
            imageEvent = (QueueListener.Event)queue.get(1);
        }
        if (imageEvent != null && imageEvent.eventParameters[3] instanceof Map && ((Map)imageEvent.eventParameters[3]).containsKey(IMAGE_LABEL_PARAMETER)) {
            Map imageParameters = (Map)imageEvent.eventParameters[3];
            String label = (String)imageParameters.get(IMAGE_LABEL_PARAMETER);
            if (imageParameters.size() == 1) {
                imageEvent.eventParameters[3] = Listener.EMPTY_PARAMETERS;
            } else {
                imageParameters.remove(IMAGE_LABEL_PARAMETER);
            }
            LinkedHashMap<String, String> figureParameters = new LinkedHashMap<String, String>(paragraphParameters);
            figureParameters.merge(CLASS_PARAMETER, IMAGE_CLASS, (oldValue, newValue) -> {
                if (Arrays.asList(StringUtils.split((String)oldValue)).contains(newValue)) {
                    return oldValue;
                }
                return oldValue + " " + newValue;
            });
            this.getListener().beginFigure(figureParameters);
            queue.consumeEvents(this.getListener());
            this.getListener().beginFigureCaption(Listener.EMPTY_PARAMETERS);
            try {
                WrappingListener wrapper = new WrappingListener(){

                    public void beginDocument(MetaData metadata) {
                    }

                    public void endDocument(MetaData metadata) {
                    }
                };
                wrapper.setWrappedListener(this.getListener());
                this.imageLabelParser.parse((Reader)new StringReader(label), (Listener)wrapper, this.getIdGenerator());
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            this.getListener().endFigureCaption(Listener.EMPTY_PARAMETERS);
            this.getListener().endFigure(figureParameters);
        } else {
            this.getListener().beginParagraph(paragraphParameters);
            queue.consumeEvents(this.getListener());
            this.getListener().endParagraph(paragraphParameters);
        }
    }

    private static boolean isLinkWrappedImage(QueueListener queue) {
        return queue.size() == 3 && ((QueueListener.Event)queue.getFirst()).eventType == EventType.BEGIN_LINK && ((QueueListener.Event)queue.get((int)1)).eventType == EventType.ON_IMAGE && ((QueueListener.Event)queue.getLast()).eventType == EventType.END_LINK;
    }
}

