/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.renderer.xwiki20;

import java.io.Flushable;
import java.io.IOException;
import javax.inject.Inject;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.xwiki.component.descriptor.ComponentDescriptor;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.rendering.internal.listener.ListenerRegistry;
import org.xwiki.rendering.internal.renderer.xwiki20.XWikiSyntaxListenerChain;
import org.xwiki.rendering.listener.MetaData;
import org.xwiki.rendering.listener.chaining.BlockStateChainingListener;
import org.xwiki.rendering.listener.chaining.ChainingListener;
import org.xwiki.rendering.listener.chaining.ConsecutiveNewLineStateChainingListener;
import org.xwiki.rendering.listener.chaining.GroupStateChainingListener;
import org.xwiki.rendering.listener.chaining.ListenerChain;
import org.xwiki.rendering.listener.chaining.LookaheadChainingListener;
import org.xwiki.rendering.parser.ParseException;
import org.xwiki.rendering.renderer.AbstractChainingPrintRenderer;
import org.xwiki.rendering.renderer.PrintRenderer;
import org.xwiki.rendering.syntax.Syntax;
import org.xwiki.rendering.syntax.SyntaxRegistry;

public abstract class AbstractXWikiSyntaxRenderer
extends AbstractChainingPrintRenderer
implements Initializable,
Flushable {
    @Inject
    private ListenerRegistry listenerRegistry;
    @Inject
    private ComponentDescriptor<PrintRenderer> descriptor;
    @Inject
    private SyntaxRegistry syntaxRegistry;
    @Inject
    private Logger logger;

    protected abstract ChainingListener createXWikiSyntaxChainingRenderer(ListenerChain var1);

    public void initialize() throws InitializationException {
        XWikiSyntaxListenerChain chain = new XWikiSyntaxListenerChain();
        this.setListenerChain(chain);
        chain.addListener((ChainingListener)this);
        String roleHint = this.descriptor.getRoleHint();
        Syntax syntax = null;
        try {
            syntax = this.syntaxRegistry.resolveSyntax(roleHint);
        }
        catch (ParseException e) {
            this.logger.warn("Failed to find syntax [{}] in the registry during renderer initialization. Cause: [{}]", (Object)roleHint, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
        }
        this.listenerRegistry.getListeners((ListenerChain)chain, "render", syntax).forEach(arg_0 -> ((ListenerChain)chain).addListener(arg_0));
        chain.addListener((ChainingListener)new LookaheadChainingListener((ListenerChain)chain, 2));
        chain.addListener((ChainingListener)new GroupStateChainingListener((ListenerChain)chain));
        chain.addListener((ChainingListener)new BlockStateChainingListener((ListenerChain)chain));
        chain.addListener((ChainingListener)new ConsecutiveNewLineStateChainingListener((ListenerChain)chain));
        chain.addListener(this.createXWikiSyntaxChainingRenderer(chain));
    }

    @Override
    public void flush() throws IOException {
        this.endDocument(MetaData.EMPTY);
    }
}

