/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.renderer.xwiki20;

import java.util.ArrayDeque;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.xwiki.rendering.internal.renderer.xwiki20.XWikiSyntaxEscapeHandler;
import org.xwiki.rendering.internal.renderer.xwiki20.XWikiSyntaxListenerChain;
import org.xwiki.rendering.renderer.printer.LookaheadWikiPrinter;
import org.xwiki.rendering.renderer.printer.WikiPrinter;

public class XWikiSyntaxEscapeWikiPrinter
extends LookaheadWikiPrinter {
    private static final Pattern VERBATIM_PATTERN = Pattern.compile("(\\{\\{\\{)|(\\}\\}\\})");
    private XWikiSyntaxListenerChain listenerChain;
    private XWikiSyntaxEscapeHandler escapeHandler = new XWikiSyntaxEscapeHandler();
    private boolean escapeLastChar;
    private Pattern escapeFirstIfMatching;
    private String lastPrinted;

    public XWikiSyntaxEscapeWikiPrinter(WikiPrinter printer, XWikiSyntaxListenerChain listenerChain) {
        super(printer);
        this.listenerChain = listenerChain;
    }

    public XWikiSyntaxEscapeHandler getEscapeHandler() {
        return this.escapeHandler;
    }

    protected void printInternal(String text) {
        super.printInternal(text);
        int length = text.length();
        if (length > 0) {
            this.escapeHandler.setOnNewLine(text.charAt(length - 1) == '\n');
        }
        this.lastPrinted = text;
    }

    protected void printlnInternal(String text) {
        super.printlnInternal(text);
        this.escapeHandler.setOnNewLine(true);
        this.lastPrinted = "\n";
    }

    public void flush() {
        if (this.getBuffer().length() > 0) {
            this.escapeHandler.escape(this.getBuffer(), this.listenerChain, this.escapeLastChar, this.escapeFirstIfMatching);
            super.flush();
        }
        this.escapeLastChar = false;
        this.escapeFirstIfMatching = null;
    }

    public void printBeginBold() {
        this.flush();
        boolean isOnNewLine = this.escapeHandler.isOnNewLine();
        this.print("**");
        if (isOnNewLine) {
            this.escapeFirstIfMatching = XWikiSyntaxEscapeHandler.STARLISTEND_PATTERN;
        }
    }

    public void setEscapeLastChar(boolean escapeLastChar) {
        this.escapeLastChar = escapeLastChar;
    }

    public void setOnNewLine(boolean onNewLine) {
        this.escapeHandler.setOnNewLine(onNewLine);
    }

    public boolean isOnNewLine() {
        return this.escapeHandler.isOnNewLine();
    }

    public boolean isAfterWhiteSpace() {
        return this.isOnNewLine() || Character.isWhitespace(this.getLastPrinted().charAt(this.getLastPrinted().length() - 1));
    }

    public String getLastPrinted() {
        return this.lastPrinted;
    }

    public void printBeginItalic() {
        if (this.getBuffer().length() > 0 && this.getBuffer().charAt(this.getBuffer().length() - 1) == ':') {
            this.escapeLastChar = true;
        }
        this.print("//");
    }

    public void printEndItalic() {
        if (this.getBuffer().length() > 0 && this.getBuffer().charAt(this.getBuffer().length() - 1) == ':') {
            this.escapeLastChar = true;
        }
        this.print("//");
    }

    public void printInlineMacro(String xwikiSyntaxText) {
        if (this.getBuffer().length() > 0 && this.getBuffer().charAt(this.getBuffer().length() - 1) == '{') {
            this.escapeLastChar = true;
        }
        this.print(xwikiSyntaxText);
    }

    public void printVerbatimContent(String verbatimContent) {
        StringBuffer subVerbatim;
        StringBuffer result = new StringBuffer();
        ArrayDeque<StringBuffer> subVerbatimStack = new ArrayDeque<StringBuffer>();
        boolean printEndVerbatim = false;
        Matcher matcher = VERBATIM_PATTERN.matcher(verbatimContent);
        int currentIndex = 0;
        while (matcher.find()) {
            String before = verbatimContent.substring(currentIndex, matcher.start());
            if (printEndVerbatim) {
                if (before.startsWith("}")) {
                    result.append("~}~}~}");
                } else {
                    result.append("~}}}");
                }
            }
            if (subVerbatimStack.isEmpty()) {
                result.append(before);
            } else {
                ((StringBuffer)subVerbatimStack.peek()).append(before);
            }
            if (matcher.group(1) != null) {
                subVerbatimStack.push(new StringBuffer());
            } else if (subVerbatimStack.isEmpty()) {
                printEndVerbatim = true;
            } else {
                subVerbatim = (StringBuffer)subVerbatimStack.pop();
                if (subVerbatimStack.isEmpty()) {
                    result.append("{{{");
                    result.append(subVerbatim);
                    result.append("}}}");
                } else {
                    ((StringBuffer)subVerbatimStack.peek()).append("{{{");
                    ((StringBuffer)subVerbatimStack.peek()).append(subVerbatim);
                    ((StringBuffer)subVerbatimStack.peek()).append("}}}");
                }
            }
            currentIndex = matcher.end();
        }
        if (currentIndex == 0) {
            this.print(verbatimContent);
            return;
        }
        String end = verbatimContent.substring(currentIndex);
        if (printEndVerbatim) {
            if (end.length() == 0 || end.charAt(0) == '}') {
                result.append("~}~}~}");
            } else {
                result.append("~}}}");
            }
        }
        if (!subVerbatimStack.isEmpty()) {
            ((StringBuffer)subVerbatimStack.peek()).append(end);
            while (!subVerbatimStack.isEmpty()) {
                subVerbatim = (StringBuffer)subVerbatimStack.pop();
                if (subVerbatimStack.isEmpty()) {
                    if (subVerbatim.length() > 0 && subVerbatim.charAt(0) == '{') {
                        result.append("~{~{~{");
                    } else {
                        result.append("~{{{");
                    }
                    result.append(subVerbatim);
                    continue;
                }
                if (subVerbatim.length() > 0 && subVerbatim.charAt(0) == '{') {
                    ((StringBuffer)subVerbatimStack.peek()).append("~{~{~{");
                } else {
                    ((StringBuffer)subVerbatimStack.peek()).append("~{{{");
                }
                ((StringBuffer)subVerbatimStack.peek()).append(subVerbatim);
            }
        } else {
            result.append(end);
        }
        this.print(result.toString());
    }
}

