/*
 * Decompiled with CFR 0.152.
 */
package org.yop.reflection;

import com.google.common.primitives.Primitives;
import com.google.common.reflect.TypeToken;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yop.reflection.ReflectionCache;
import org.yop.reflection.ReflectionException;
import sun.reflect.ReflectionFactory;

public class Reflection {
    private static final Logger logger = LoggerFactory.getLogger(Reflection.class);
    private static final boolean TEST_BOOL = true;
    private static final byte TEST_BYTE = 111;
    private static final char TEST_CHAR = '*';
    private static final short TEST_SHORT = 42;
    private static final int TEST_INT = 1337;
    private static final long TEST_LONG = 1337666L;
    private static final float TEST_FLOAT = 13.37f;
    private static final double TEST_DOUBLE = 1.337;

    public static <T> Class<T> forName(String name, ClassLoader ... classLoaders) {
        try {
            for (ClassLoader classLoader : classLoaders) {
                try {
                    return classLoader.loadClass(name);
                }
                catch (ClassNotFoundException e) {
                    logger.debug("Class [{}] not found in class loader [{}]", new Object[]{name, classLoader, e});
                }
            }
            return Class.forName(name);
        }
        catch (ClassNotFoundException e) {
            throw new ReflectionException("Could not find class for name [" + name + "]", e);
        }
    }

    public static String packageName(Class<?> clazz) {
        return clazz == null || clazz.getPackage() == null ? "" : clazz.getPackage().getName();
    }

    public static Method getMethod(Class<?> clazz, String name, Class<?> ... parameterTypes) {
        try {
            Method method = clazz.getDeclaredMethod(name, parameterTypes);
            method.setAccessible(true);
            return method;
        }
        catch (NoSuchMethodException e) {
            logger.debug("No method [{}]#[{}] with parameter types {}", new Object[]{clazz, name, parameterTypes, e});
            return null;
        }
    }

    public static Set<Method> getMethods(Class<?> target) {
        HashSet<Method> allMethods = new HashSet<Method>();
        Method[] declaredMethods = target.getDeclaredMethods();
        Method[] methods = target.getMethods();
        if (target.getSuperclass() != null) {
            Class<?> superClass = target.getSuperclass();
            allMethods.addAll(Reflection.getMethods(superClass));
        }
        if (target.getInterfaces() != null) {
            Class<?>[] interfaces = target.getInterfaces();
            Arrays.stream(interfaces).forEach(superInterface -> allMethods.addAll(Reflection.getMethods(superInterface)));
        }
        allMethods.addAll(Arrays.asList(declaredMethods));
        allMethods.addAll(Arrays.asList(methods));
        return allMethods;
    }

    public static <A extends Annotation> A getAnnotation(Class target, Class<A> annotation) {
        for (Class i = target; i != null && i != Object.class; i = i.getSuperclass()) {
            if (!i.isAnnotationPresent(annotation)) continue;
            return i.getAnnotation(annotation);
        }
        TypeToken.TypeSet typeTokens = TypeToken.of((Class)target).getTypes().interfaces();
        for (TypeToken typeToken : typeTokens) {
            if (!typeToken.getRawType().isAnnotationPresent(annotation)) continue;
            return typeToken.getRawType().getAnnotation(annotation);
        }
        return null;
    }

    public static List<Field> getFields(Class type) {
        ArrayList<Field> result = new ArrayList<Field>();
        for (Class i = type; i != null && i != Object.class; i = i.getSuperclass()) {
            for (Field field : ReflectionCache.getDeclaredFields(i)) {
                if (field.isSynthetic()) continue;
                field.setAccessible(true);
                result.add(field);
            }
        }
        return result;
    }

    public static List<Field> getFields(Class type, Class<? extends Annotation> withAnnotation) {
        ArrayList<Field> result = new ArrayList<Field>();
        for (Class i = type; i != null && i != Object.class; i = i.getSuperclass()) {
            for (Field field : ReflectionCache.getDeclaredFields(i)) {
                if (field.isSynthetic() || !field.isAnnotationPresent(withAnnotation)) continue;
                field.setAccessible(true);
                result.add(field);
            }
        }
        return result;
    }

    public static String fieldToString(Field field) {
        return field == null ? "null" : field.getDeclaringClass().getName() + "#" + field.getName();
    }

    public static Object readField(Field field, Object onto) {
        try {
            return field.get(onto);
        }
        catch (IllegalAccessException | RuntimeException e) {
            throw new ReflectionException("Could not read [" + Reflection.fieldToString(field) + "] on [" + onto + "]", e);
        }
    }

    public static Object readField(String fieldName, Object onto) {
        try {
            Field field = Reflection.get(onto.getClass(), fieldName);
            if (field == null) {
                throw new ReflectionException("No field [" + fieldName + "] in [" + onto.getClass().getName() + "]");
            }
            return field.get(onto);
        }
        catch (IllegalAccessException | RuntimeException e) {
            throw new ReflectionException("Could not read [" + fieldName + "] on [" + onto + "]", e);
        }
    }

    public static Field get(Class type, String name) {
        for (Class i = type; i != null && i != Object.class; i = i.getSuperclass()) {
            for (Field field : ReflectionCache.getDeclaredFields(i)) {
                if (field.isSynthetic() || !StringUtils.equals((CharSequence)field.getName(), (CharSequence)name)) continue;
                field.setAccessible(true);
                return field;
            }
        }
        return null;
    }

    public static void set(Field field, Object onto, Object value) {
        try {
            field.set(onto, value);
        }
        catch (IllegalAccessException | RuntimeException e) {
            throw new ReflectionException("Unable to set field [" + field.getDeclaringClass() + "#" + field.getName() + "] value [" + value + "] onto  [" + onto + "]", e);
        }
    }

    public static void setFrom(Field field, Object from, Object onto) {
        try {
            Reflection.set(field, onto, Reflection.readField(field, from));
        }
        catch (RuntimeException e) {
            throw new ReflectionException("Unable to set field [" + field.getDeclaringClass() + "#" + field.getName() + "] from [" + from + "] onto [" + onto + "]", e);
        }
    }

    public static Type get1ArgParameter(Field field) {
        Type genericType = field.getGenericType();
        if (!(genericType instanceof ParameterizedType)) {
            throw new ReflectionException(Reflection.concat("Field [", Reflection.fieldToString(field), "] is not generic. Unsupported."));
        }
        ParameterizedType type = (ParameterizedType)genericType;
        Type[] typeParameter = type.getActualTypeArguments();
        if (typeParameter.length != 1) {
            throw new ReflectionException(Reflection.concat("Field [", Reflection.fieldToString(field), "] has [", typeParameter.length, "] parameters. Unsupported."));
        }
        return typeParameter[0] instanceof ParameterizedType ? ((ParameterizedType)typeParameter[0]).getRawType() : typeParameter[0];
    }

    public static <T> T newInstanceNoArgs(Class<T> clazz) {
        try {
            Constructor<T> c = clazz.getDeclaredConstructor(new Class[0]);
            c.setAccessible(true);
            return c.newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException | RuntimeException e) {
            throw new ReflectionException("Unable to create instance of [" + clazz + "]. Does it have a no-arg constructor?", e);
        }
    }

    public static <T, R> Field findField(Class<T> clazz, Function<T, R> getter) {
        Class<?> fieldType = null;
        try {
            List<Field> fields = Reflection.getFields(clazz);
            T instance = Reflection.newInstanceNoArgs(clazz);
            for (Field field : fields) {
                fieldType = field.getType();
                Object testValue = Reflection.newInstanceUnsafe(fieldType);
                Reflection.set(field, instance, testValue);
                R fieldValue = getter.apply(instance);
                if (testValue == fieldValue && !ClassUtils.isPrimitiveOrWrapper(fieldType)) {
                    return field;
                }
                if (!Reflection.primitiveCheck(field, getter, instance, testValue, fieldValue)) continue;
                return field;
            }
        }
        catch (RuntimeException e) {
            throw new ReflectionException("Unable to find field from [" + clazz + "] for the given accessors ! Last field type was [" + fieldType + "]", e);
        }
        throw new ReflectionException("Unable to find field from [" + clazz + "] for the given accessors !");
    }

    private static <T, R> boolean primitiveCheck(Field field, Function<T, R> getter, T instance, Object testValue, R fieldValue) {
        if (ClassUtils.isPrimitiveOrWrapper(field.getType()) && testValue != null && testValue.equals(fieldValue)) {
            Object confirmValue = Reflection.primitiveTestValue(field.getType(), (short)1);
            Reflection.set(field, instance, confirmValue);
            return getter.apply(instance).equals(confirmValue);
        }
        return false;
    }

    public static <T, R> Field findField(Class<T> clazz, BiConsumer<T, R> setter) {
        try {
            List<Field> fields = Reflection.getFields(clazz);
            T instance = Reflection.newInstanceNoArgs(clazz);
            for (Field field : fields) {
                Class<?> fieldType = field.getType();
                try {
                    Object testValue = Reflection.newInstanceUnsafe(fieldType);
                    setter.accept(instance, testValue);
                    Object fieldValue = Reflection.readField(field, instance);
                    if (testValue == fieldValue) {
                        return field;
                    }
                    if (!ClassUtils.isPrimitiveOrWrapper(fieldType) || testValue == null || !testValue.equals(fieldValue)) continue;
                    return field;
                }
                catch (RuntimeException e) {
                    logger.trace("Wrong field for setter ! Next guess maybe :-)", (Throwable)e);
                }
            }
        }
        catch (RuntimeException e) {
            throw new ReflectionException("Unable to find field from [" + clazz + "] for the given accessors !", e);
        }
        throw new ReflectionException("Unable to find field from [" + clazz + "] for the given accessors !");
    }

    public static <T> Class<T> getCollectionTarget(Field field) {
        return (Class)((ParameterizedType)field.getGenericType()).getActualTypeArguments()[0];
    }

    public static <T> Class<T> getTarget(Field field) {
        if (Collection.class.isAssignableFrom(field.getType())) {
            return Reflection.getCollectionTarget(field);
        }
        return field.getType();
    }

    public static <S, T> Class<T> getGetterTarget(Class<S> source, Function<S, T> getter) {
        return Reflection.findField(source, getter).getType();
    }

    public static <S, T> Class<T> getSetterTarget(Class<S> source, BiConsumer<S, T> setter) {
        return Reflection.findField(source, setter).getType();
    }

    public static <S, T> Class<T> getGetterCollectionTarget(Class<S> source, Function<S, ? extends Collection<T>> getter) {
        return (Class)((ParameterizedType)Reflection.findField(source, getter).getGenericType()).getActualTypeArguments()[0];
    }

    public static <S, T> Class<T> getSetterCollectionTarget(Class<S> source, BiConsumer<S, ? extends Collection<T>> setter) {
        return (Class)((ParameterizedType)Reflection.findField(source, setter).getGenericType()).getActualTypeArguments()[0];
    }

    private static <T> T newInstanceUnsafe(Class<T> clazz) {
        if (ClassUtils.isPrimitiveOrWrapper(clazz)) {
            return (T)Reflection.primitiveTestValue(clazz, (short)0);
        }
        Class<T> target = Reflection.implementationOf(clazz);
        try {
            return Reflection.newInstanceNoArgs(target);
        }
        catch (RuntimeException e) {
            logger.trace("Unable to use no-arg constructor of [" + clazz.getName() + "]. Fallback to Unsafe...", (Throwable)e);
            try {
                Constructor<?> silentConstructor = ReflectionFactory.getReflectionFactory().newConstructorForSerialization(target, Object.class.getDeclaredConstructor(new Class[0]));
                silentConstructor.setAccessible(true);
                return (T)silentConstructor.newInstance(new Object[0]);
            }
            catch (ReflectiveOperationException | RuntimeException e2) {
                throw new RuntimeException("Unable to unsafe create instance of [" + clazz.getName() + "] !", e2);
            }
        }
    }

    private static Object primitiveTestValue(Class<?> primitive, short salt) {
        boolean confirm;
        Class unwrapped = primitive.isPrimitive() ? primitive : Primitives.unwrap(primitive);
        boolean bl = confirm = salt > 0;
        if (Boolean.TYPE.equals(unwrapped)) {
            return !confirm;
        }
        if (Byte.TYPE.equals(unwrapped)) {
            return (byte)(111 + salt);
        }
        if (Character.TYPE.equals(unwrapped)) {
            return Character.valueOf((char)(42 + salt));
        }
        if (Short.TYPE.equals(unwrapped)) {
            return (short)(42 + salt);
        }
        if (Integer.TYPE.equals(unwrapped)) {
            return 1337 + salt;
        }
        if (Long.TYPE.equals(unwrapped)) {
            return 1337666L + (long)salt;
        }
        if (Float.TYPE.equals(unwrapped)) {
            return Float.valueOf(13.37f + (float)salt);
        }
        if (Double.TYPE.equals(unwrapped)) {
            return 1.337 + (double)salt;
        }
        throw new ReflectionException("Primitive class [" + primitive.getName() + "] is not really primitive !");
    }

    static <T> boolean isConcrete(Class<T> clazz) {
        return !clazz.isInterface() && !Modifier.isAbstract(clazz.getModifiers());
    }

    private static <T> Class<? extends T> implementationOf(Class<T> clazz) {
        return ReflectionCache.implementationOf(clazz);
    }

    public static <T> Constructor<T> getConstructor(Class<T> on, Class<?> withParameter) {
        try {
            Constructor<T> constructor = on.getDeclaredConstructor(withParameter);
            constructor.setAccessible(true);
            return constructor;
        }
        catch (NoSuchMethodException e) {
            logger.trace("Could not find constructor [{}]([{}])", new Object[]{on.getName(), withParameter.getName(), e});
            return null;
        }
    }

    private static String concat(Object ... objects) {
        StringBuilder builder = new StringBuilder();
        for (Object o : objects) {
            builder.append(String.valueOf(o));
        }
        return builder.toString();
    }
}

