/*
 * Decompiled with CFR 0.152.
 */
package org.yop.reflection;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import org.apache.commons.collections4.MultiValuedMap;
import org.apache.commons.collections4.multimap.ArrayListValuedHashMap;
import org.reflections.Reflections;
import org.yop.reflection.Reflection;

class ReflectionCache {
    private static final MultiValuedMap<Class, Field> DECLARED_FIELDS = new ArrayListValuedHashMap();
    private static final Map<Class<?>, Class<?>> KNOWN_IMPLEMENTATIONS = new HashMap<Class<?>, Class<?>>(){
        {
            this.put(Iterable.class, ArrayList.class);
            this.put(Collection.class, ArrayList.class);
            this.put(List.class, ArrayList.class);
            this.put(Set.class, HashSet.class);
            this.put(Queue.class, LinkedList.class);
            this.put(Map.class, HashMap.class);
            this.put(Calendar.class, GregorianCalendar.class);
        }
    };

    ReflectionCache() {
    }

    static Collection<Field> getDeclaredFields(Class clazz) {
        if (!DECLARED_FIELDS.containsKey((Object)clazz)) {
            DECLARED_FIELDS.putAll((Object)clazz, Arrays.asList(clazz.getDeclaredFields()));
        }
        return DECLARED_FIELDS.get((Object)clazz);
    }

    static <T> Class<? extends T> implementationOf(Class<T> clazz) {
        if (Reflection.isConcrete(clazz)) {
            return clazz;
        }
        if (KNOWN_IMPLEMENTATIONS.containsKey(clazz)) {
            return KNOWN_IMPLEMENTATIONS.get(clazz);
        }
        Set subTypes = new Reflections(new Object[0]).getSubTypesOf(clazz);
        Class impl = subTypes.stream().filter(Reflection::isConcrete).findFirst().orElse(null);
        KNOWN_IMPLEMENTATIONS.put(clazz, impl);
        return impl;
    }
}

