/*
 * Decompiled with CFR 0.152.
 */
package org.yamj.api.common.http;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.nio.charset.Charset;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Consts;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.protocol.RequestAddCookies;
import org.apache.http.client.protocol.RequestAuthCache;
import org.apache.http.client.protocol.RequestClientConnControl;
import org.apache.http.client.protocol.RequestDefaultHeaders;
import org.apache.http.client.protocol.RequestProxyAuthentication;
import org.apache.http.client.protocol.RequestTargetAuthentication;
import org.apache.http.client.protocol.ResponseProcessCookies;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.params.ConnRouteParams;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.impl.client.AbstractHttpClient;
import org.apache.http.impl.conn.PoolingClientConnectionManager;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;
import org.apache.http.params.SyncBasicHttpParams;
import org.apache.http.protocol.BasicHttpProcessor;
import org.apache.http.protocol.RequestContent;
import org.apache.http.protocol.RequestExpectContinue;
import org.apache.http.protocol.RequestTargetHost;
import org.apache.http.protocol.RequestUserAgent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yamj.api.common.http.CommonHttpClient;

public abstract class AbstractPoolingHttpClient
extends AbstractHttpClient
implements CommonHttpClient {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractPoolingHttpClient.class);
    private String proxyHost = null;
    private int proxyPort = 0;
    private String proxyUsername = null;
    private String proxyPassword = null;
    private int connectionTimeout = 25000;
    private int socketTimeout = 90000;
    private int connectionsMaxPerRoute = 1;
    private int connectionsMaxTotal = 20;

    public AbstractPoolingHttpClient(ClientConnectionManager connectionManager, HttpParams httpParams) {
        super(connectionManager, httpParams);
    }

    @Override
    public void setProxy(String host, int port, String username, String password) {
        this.setProxyHost(host);
        this.setProxyPort(port);
        this.setProxyUsername(username);
        this.setProxyPassword(password);
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public void setProxyPort(int proxyPort) {
        this.proxyPort = proxyPort;
    }

    public void setProxyUsername(String proxyUsername) {
        this.proxyUsername = proxyUsername;
    }

    public void setProxyPassword(String proxyPassword) {
        this.proxyPassword = proxyPassword;
    }

    @Override
    public void setTimeouts(int connectionTimeout, int socketTimeout) {
        this.setConnectionTimeout(connectionTimeout);
        this.setSocketTimeout(socketTimeout);
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public void setSocketTimeout(int socketTimeout) {
        this.socketTimeout = socketTimeout;
    }

    public void setConnectionsMaxPerRoute(int connectionsMaxPerRoute) {
        this.connectionsMaxPerRoute = connectionsMaxPerRoute;
    }

    public void setConnectionsMaxTotal(int connectionsMaxTotal) {
        this.connectionsMaxTotal = connectionsMaxTotal;
    }

    protected HttpParams createHttpParams() {
        SyncBasicHttpParams params = new SyncBasicHttpParams();
        HttpProtocolParams.setVersion((HttpParams)params, (ProtocolVersion)HttpVersion.HTTP_1_1);
        HttpProtocolParams.setContentCharset((HttpParams)params, (String)Consts.UTF_8.name());
        HttpConnectionParams.setTcpNoDelay((HttpParams)params, (boolean)true);
        HttpConnectionParams.setSocketBufferSize((HttpParams)params, (int)8192);
        HttpConnectionParams.setConnectionTimeout((HttpParams)params, (int)this.connectionTimeout);
        HttpConnectionParams.setSoTimeout((HttpParams)params, (int)this.socketTimeout);
        if (StringUtils.isNotBlank((CharSequence)this.proxyHost) && this.proxyPort > 0) {
            if (StringUtils.isNotBlank((CharSequence)this.proxyUsername) && StringUtils.isNotBlank((CharSequence)this.proxyPassword)) {
                this.getCredentialsProvider().setCredentials(new AuthScope(this.proxyHost, this.proxyPort), (Credentials)new UsernamePasswordCredentials(this.proxyUsername, this.proxyPassword));
            }
            HttpHost proxy = new HttpHost(this.proxyHost, this.proxyPort);
            ConnRouteParams.setDefaultProxy((HttpParams)params, (HttpHost)proxy);
        }
        return params;
    }

    protected BasicHttpProcessor createHttpProcessor() {
        BasicHttpProcessor httpproc = new BasicHttpProcessor();
        httpproc.addInterceptor((HttpRequestInterceptor)new RequestDefaultHeaders());
        httpproc.addInterceptor((HttpRequestInterceptor)new RequestContent());
        httpproc.addInterceptor((HttpRequestInterceptor)new RequestTargetHost());
        httpproc.addInterceptor((HttpRequestInterceptor)new RequestClientConnControl());
        httpproc.addInterceptor((HttpRequestInterceptor)new RequestUserAgent());
        httpproc.addInterceptor((HttpRequestInterceptor)new RequestExpectContinue());
        httpproc.addInterceptor((HttpRequestInterceptor)new RequestAddCookies());
        httpproc.addInterceptor((HttpResponseInterceptor)new ResponseProcessCookies());
        httpproc.addInterceptor((HttpRequestInterceptor)new RequestAuthCache());
        httpproc.addInterceptor((HttpRequestInterceptor)new RequestTargetAuthentication());
        httpproc.addInterceptor((HttpRequestInterceptor)new RequestProxyAuthentication());
        return httpproc;
    }

    protected ClientConnectionManager createClientConnectionManager() {
        PoolingClientConnectionManager clientManager = new PoolingClientConnectionManager();
        clientManager.setDefaultMaxPerRoute(this.connectionsMaxPerRoute);
        clientManager.setMaxTotal(this.connectionsMaxTotal);
        return clientManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String readContent(HttpResponse response, Charset charset) throws IOException {
        StringWriter content = new StringWriter(10240);
        InputStream is = response.getEntity().getContent();
        InputStreamReader isr = null;
        BufferedReader br = null;
        try {
            isr = charset == null ? new InputStreamReader(is, Charset.defaultCharset()) : new InputStreamReader(is, charset);
            br = new BufferedReader(isr);
            String line = br.readLine();
            while (line != null) {
                content.write(line);
                line = br.readLine();
            }
            content.flush();
            String string = content.toString();
            return string;
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException ex) {
                    LOG.trace("Failed to close BufferedReader", (Throwable)ex);
                }
            }
            if (isr != null) {
                try {
                    isr.close();
                }
                catch (IOException ex) {
                    LOG.trace("Failed to close InputStreamReader", (Throwable)ex);
                }
            }
            try {
                content.close();
            }
            catch (IOException ex) {
                LOG.trace("Failed to close StringWriter", (Throwable)ex);
            }
            try {
                is.close();
            }
            catch (IOException ex) {
                LOG.trace("Failed to close InputStream", (Throwable)ex);
            }
        }
    }

    public void setRoute(HttpRoute httpRoute, int maxRequests) {
        ClientConnectionManager conMan = this.getConnectionManager();
        if (conMan instanceof PoolingClientConnectionManager) {
            PoolingClientConnectionManager poolMan = (PoolingClientConnectionManager)conMan;
            poolMan.setMaxPerRoute(httpRoute, maxRequests);
        }
    }
}

