/*
 * Decompiled with CFR 0.152.
 */
package org.yamj.api.common.tools;

import org.yamj.api.common.exception.ApiException;
import org.yamj.api.common.http.DigestedResponse;

public final class ResponseTools {
    private ResponseTools() {
        throw new UnsupportedOperationException("Utility class");
    }

    public static boolean isOK(DigestedResponse response) {
        return ResponseTools.isOK(response.getStatusCode());
    }

    public static boolean isOK(ApiException apiException) {
        return ResponseTools.isOK(apiException.getResponseCode());
    }

    public static boolean isOK(int statusCode) {
        return statusCode == 200;
    }

    public static boolean isNotOK(DigestedResponse response) {
        return !ResponseTools.isOK(response);
    }

    public static boolean isNotOK(ApiException apiException) {
        return ResponseTools.isNotOK(apiException.getResponseCode());
    }

    public static boolean isNotOK(int statusCode) {
        return !ResponseTools.isOK(statusCode);
    }

    public static boolean isTemporaryError(DigestedResponse response) {
        return ResponseTools.isTemporaryError(response.getStatusCode());
    }

    public static boolean isTemporaryError(ApiException apiException) {
        return ResponseTools.isTemporaryError(apiException.getResponseCode());
    }

    public static boolean isTemporaryError(int statusCode) {
        switch (statusCode) {
            case 408: 
            case 419: 
            case 423: 
            case 429: 
            case 500: 
            case 502: 
            case 503: 
            case 504: 
            case 507: 
            case 509: 
            case 598: 
            case 599: {
                return true;
            }
        }
        return false;
    }
}

