/*
 * Decompiled with CFR 0.152.
 */
package org.yarnandtail.andhow.testutil;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.junit.platform.commons.support.HierarchyTraversalMode;
import org.junit.platform.commons.support.ReflectionSupport;

public final class ReflectionTestUtils {
    public static final String PERMISSION_MSG = "There is some type of permissions/access error - See the underlying error message.";

    private ReflectionTestUtils() {
    }

    public static String stringMethod(Object instance, String name, Object[] args, Class<?>[] types) {
        return (String)ReflectionTestUtils.invokeInstanceMethod(instance, name, args, types);
    }

    public static String stringMethod(Object instance, String name, Object arg, Class<?> type) {
        return (String)ReflectionTestUtils.invokeInstanceMethod(instance, name, new Object[]{arg}, new Class[]{type});
    }

    public static String stringMethod(Object instance, String name, Object ... args) {
        return (String)ReflectionTestUtils.invokeInstanceMethod(instance, name, args, ReflectionTestUtils.getTypes(args));
    }

    public static Object invokeInstanceMethod(Object instance, String name, Object[] args, Class<?>[] types) {
        Optional method = ReflectionSupport.findMethod(instance.getClass(), (String)name, (Class[])types);
        if (method.isPresent()) {
            return ReflectionTestUtils.invokeMethod((Method)method.get(), instance, args);
        }
        throw new IllegalArgumentException("Method not found");
    }

    public static Object invokeStaticMethod(Class<?> clazz, String name, Object[] args, Class<?>[] types) {
        Optional method = ReflectionSupport.findMethod(clazz, (String)name, (Class[])types);
        if (method.isPresent()) {
            return ReflectionTestUtils.invokeMethod((Method)method.get(), null, args);
        }
        throw new IllegalArgumentException("Method not found");
    }

    public static Object invokeMethod(Method method, Object instance, Object[] args) {
        try {
            method.setAccessible(true);
            return method.invoke(instance, args);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static <T> T getInstanceFieldValue(Object instance, String fieldName, Class<T> fieldType) {
        Field field = ReflectionTestUtils.getWritableField(instance.getClass(), fieldName);
        return (T)ReflectionTestUtils.getFieldValue(field, instance);
    }

    public static <T> T setInstanceFieldValue(Object instance, String fieldName, T fieldValue, Class<T> fieldType) {
        Field field = ReflectionTestUtils.getWritableField(instance.getClass(), fieldName);
        return (T)ReflectionTestUtils.setFieldValue(field, instance, fieldValue);
    }

    public static <T> T getStaticFieldValue(Class<?> clazz, String fieldName, Class<T> fieldType) {
        Field field = ReflectionTestUtils.getWritableField(clazz, fieldName);
        return (T)ReflectionTestUtils.getFieldValue(field, null);
    }

    public static <T> T setStaticFieldValue(Class<?> clazz, String fieldName, T value) {
        Field field = ReflectionTestUtils.getWritableField(clazz, fieldName);
        return (T)ReflectionTestUtils.setFieldValue(field, null, value);
    }

    public static Object getFieldValue(Field field, Object instance) {
        try {
            return field.get(instance);
        }
        catch (Exception ex) {
            throw new RuntimeException(PERMISSION_MSG, ex);
        }
    }

    public static Object setFieldValue(Field field, Object instance, Object value) {
        Object orgVal = ReflectionTestUtils.getFieldValue(field, instance);
        try {
            field.set(instance, value);
        }
        catch (Exception ex) {
            throw new RuntimeException(PERMISSION_MSG, ex);
        }
        return orgVal;
    }

    public static Field getWritableField(Class<?> clazz, String fieldName) {
        List fields = ReflectionSupport.findFields(clazz, f -> f.getName().equals(fieldName), (HierarchyTraversalMode)HierarchyTraversalMode.BOTTOM_UP);
        if (fields.size() != 1) {
            throw new IllegalArgumentException("Expected to find 1 field, instead found: " + fields.size());
        }
        Field field = (Field)fields.get(0);
        field.setAccessible(true);
        return field;
    }

    public static Class<?>[] getTypes(Object ... args) {
        List<Object> types = new ArrayList();
        if (args != null) {
            types = Arrays.stream(args).map(a -> a.getClass()).collect(Collectors.toList());
        }
        return types.toArray(new Class[types.size()]);
    }

    public static Class<?> getClassByName(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }
}

