/*
 * ============================================================================
 * (C) Copyright Schalk W. Cronje 2016 - 2023
 *
 * This software is licensed under the Apache License 2.0
 * See http://www.apache.org/licenses/LICENSE-2.0 for license details
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 * ============================================================================
 */
package org.ysb33r.grolifant.api.v4

import groovy.transform.CompileStatic
import groovy.transform.InheritConstructors
import org.ysb33r.grolifant.api.core.PropertyResolveOrder

/** Resolves properties in a certain i.e. like SpringBoot, but
 * less functionality to suite Gradle context.
 *
 * @author Schalk W. Cronjé
 *
 * @since 0.15.0
 *
 * @deprecated Use {org.ysb33r.grolifant.api.core.resolvers.PropertyResolver} instead
 */
@CompileStatic
@Deprecated
@InheritConstructors
@SuppressWarnings('ClassNameSameAsSuperclass')
class PropertyResolver extends org.ysb33r.grolifant.api.core.resolvers.PropertyResolver {
    public static final PropertyResolveOrder PROJECT_SYSTEM_ENV =
        org.ysb33r.grolifant.api.core.resolvers.PropertyResolver.PROJECT_SYSTEM_ENV
    public static final PropertyResolveOrder SYSTEM_ENV_PROPERTY =
        org.ysb33r.grolifant.api.core.resolvers.PropertyResolver.SYSTEM_ENV_PROPERTY
}
