/*
 * Decompiled with CFR 0.152.
 */
package org.ysb33r.grolifant.internal.v4.downloader;

import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.io.File;
import java.lang.ref.SoftReference;
import java.net.URI;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.ResourceGroovyMethods;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.gradle.wrapper.PathAssembler;
import org.gradle.wrapper.WrapperConfiguration;
import org.ysb33r.grolifant.api.core.CheckSumVerification;
import org.ysb33r.grolifant.api.core.ExclusiveFileAccess;
import org.ysb33r.grolifant.api.core.LegacyLevel;
import org.ysb33r.grolifant.api.errors.DistributionFailedException;
import org.ysb33r.grolifant.api.v4.FileUtils;
import org.ysb33r.grolifant.api.v4.UriUtils;
import org.ysb33r.grolifant.internal.v4.downloader.Downloader;

public class ArtifactDownloader
implements GroovyObject {
    private static final RequiresDownload DOWNLOAD_IF_NOT_EXISTS;
    private final ExclusiveFileAccess exclusiveFileAccessManager;
    private final URI downloadURI;
    private final File downloadRoot;
    private final File projectDir;
    private final String basePath;
    private final CheckSumVerification verifyDownloadChecksum;
    private final ArtifactUnpacker unpacker;
    private final ArtifactRootVerification verifyArtifactRoot;
    private final RequiresDownload requiresDownload;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;
    private static /* synthetic */ SoftReference $callSiteArray;

    public ArtifactDownloader(URI downloadURI, File downloadRoot, File projectDir, String basePath, ArtifactRootVerification verifyArtifactRoot, ArtifactUnpacker unpacker, CheckSumVerification verifyDownloadChecksum) {
        File file;
        RequiresDownload requiresDownload;
        ArtifactUnpacker artifactUnpacker;
        ArtifactRootVerification artifactRootVerification;
        CheckSumVerification checkSumVerification;
        String string;
        File file2;
        URI uRI;
        MetaClass metaClass;
        ExclusiveFileAccess exclusiveFileAccess;
        this.exclusiveFileAccessManager = exclusiveFileAccess = new ExclusiveFileAccess(120000, 200);
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.downloadURI = uRI = downloadURI;
        this.downloadRoot = file2 = downloadRoot;
        this.basePath = string = basePath;
        this.verifyDownloadChecksum = checkSumVerification = verifyDownloadChecksum;
        this.verifyArtifactRoot = artifactRootVerification = verifyArtifactRoot;
        this.unpacker = artifactUnpacker = unpacker;
        this.requiresDownload = requiresDownload = DOWNLOAD_IF_NOT_EXISTS;
        this.projectDir = file = projectDir;
    }

    public ArtifactDownloader(URI downloadURI, File downloadRoot, File projectDir, String basePath, RequiresDownload requiresDownload, CheckSumVerification verifyDownloadChecksum) {
        File file;
        RequiresDownload requiresDownload2;
        CheckSumVerification checkSumVerification;
        String string;
        File file2;
        URI uRI;
        MetaClass metaClass;
        ExclusiveFileAccess exclusiveFileAccess;
        this.exclusiveFileAccessManager = exclusiveFileAccess = new ExclusiveFileAccess(120000, 200);
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.downloadURI = uRI = downloadURI;
        this.downloadRoot = file2 = downloadRoot;
        this.basePath = string = basePath;
        this.verifyDownloadChecksum = checkSumVerification = verifyDownloadChecksum;
        this.requiresDownload = requiresDownload2 = requiresDownload;
        this.projectDir = file = projectDir;
    }

    public File getFromCache(String description, boolean offlineMode, Downloader downloadInstance) {
        WrapperConfiguration configuration = this.getNewWrapperConfiguration();
        PathAssembler pathAssembler = this.getPathAssembler(this.downloadRoot);
        PathAssembler.LocalDistribution localDistribution = pathAssembler.getDistribution(configuration);
        File distDir = localDistribution.getDistributionDir();
        File localDownloadedFile = localDistribution.getZipFile();
        DownloadAction downloadAction = new DownloadAction();
        boolean bl = offlineMode;
        downloadAction.setOfflineMode(bl);
        String string = description;
        downloadAction.setDescription(string);
        File file = distDir;
        downloadAction.setDistDir(file);
        File file2 = localDownloadedFile;
        downloadAction.setLocalDownloadedFile(file2);
        File file3 = new File(localDownloadedFile.getParentFile(), StringGroovyMethods.plus((String)localDownloadedFile.getName(), (CharSequence)".ok"));
        downloadAction.setMarkerFile(file3);
        URI uRI = this.downloadURI;
        downloadAction.setDownloadURI(uRI);
        URI uRI2 = configuration.getDistribution();
        downloadAction.setDistributionUrl(uRI2);
        ArtifactRootVerification artifactRootVerification = this.verifyArtifactRoot;
        downloadAction.setVerifyArtifactRoot(artifactRootVerification);
        RequiresDownload requiresDownload = this.requiresDownload;
        downloadAction.setRequiresDownload(requiresDownload);
        Downloader downloader = downloadInstance;
        downloadAction.setDownloadInstance(downloader);
        CheckSumVerification checkSumVerification = this.verifyDownloadChecksum;
        downloadAction.setVerifyDownloadChecksum(checkSumVerification);
        ArtifactUnpacker artifactUnpacker = this.unpacker;
        downloadAction.setUnpacker(artifactUnpacker);
        DownloadAction downloadAction2 = downloadAction;
        return (File)ScriptBytecodeAdapter.castToType((Object)this.exclusiveFileAccessManager.access(localDownloadedFile, (Callable)downloadAction2), File.class);
    }

    private WrapperConfiguration getNewWrapperConfiguration() {
        WrapperConfiguration configuration = new WrapperConfiguration();
        URI uRI = this.downloadURI;
        configuration.setDistribution(uRI);
        String string = this.basePath;
        configuration.setZipPath(string);
        String string2 = string;
        configuration.setDistributionPath(string2);
        WrapperConfiguration wrapperConfiguration = configuration;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)wrapperConfiguration, ArtifactDownloader.class, (GroovyObject)this, (String)"configChecksum");
        return wrapperConfiguration;
    }

    private WrapperConfiguration setConfigChecksum(WrapperConfiguration configuration) {
        CallSite[] callSiteArray = ArtifactDownloader.$getCallSiteArray();
        if (DefaultTypeTransformation.booleanUnbox((Object)this.verifyDownloadChecksum)) {
            Object object = callSiteArray[0].callGetProperty((Object)this.verifyDownloadChecksum);
            ScriptBytecodeAdapter.setProperty((Object)object, null, (Object)configuration, (String)"distributionSha256Sum");
        }
        return configuration;
    }

    private PathAssembler getPathAssembler(File resolvedDownloadRoot) {
        CallSite[] callSiteArray = ArtifactDownloader.$getCallSiteArray();
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[1].callGetProperty(LegacyLevel.class))) {
            return (PathAssembler)ScriptBytecodeAdapter.castToType((Object)callSiteArray[2].callConstructor(PathAssembler.class, (Object)resolvedDownloadRoot), PathAssembler.class);
        }
        return (PathAssembler)ScriptBytecodeAdapter.castToType((Object)callSiteArray[3].callConstructor(PathAssembler.class, (Object)resolvedDownloadRoot, (Object)this.projectDir), PathAssembler.class);
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != ArtifactDownloader.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ Object this$dist$invoke$1(String name, Object args) {
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(ArtifactDownloader.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$1(String name, Object value) {
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, ArtifactDownloader.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    public /* synthetic */ Object this$dist$get$1(String name) {
        return ScriptBytecodeAdapter.getGroovyObjectProperty(ArtifactDownloader.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    @Generated
    @Internal
    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    @Generated
    @Internal
    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    @Generated
    @Internal
    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    static {
        1 var0 = new 1(ArtifactDownloader.class);
        DOWNLOAD_IF_NOT_EXISTS = var0;
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "checksum";
        stringArray[1] = "PRE_7_1";
        stringArray[2] = "<$constructor$>";
        stringArray[3] = "<$constructor$>";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[4];
        ArtifactDownloader.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(ArtifactDownloader.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = ArtifactDownloader.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }

    public static interface ArtifactRootVerification {
        public File verify(File var1);
    }

    public static interface ArtifactUnpacker {
        public void unpack(File var1, File var2);
    }

    public static interface RequiresDownload {
        public boolean download(URI var1, File var2);
    }

    public class 1
    implements RequiresDownload,
    GroovyObject {
        public /* synthetic */ Class this$0;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;

        /* synthetic */ 1(Class p0) {
            MetaClass metaClass;
            Class clazz;
            this.this$0 = clazz = p0;
            this.metaClass = metaClass = this.$getStaticMetaClass();
        }

        @Override
        public boolean download(URI downloadURI, File localPath) {
            return !localPath.isFile();
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodN(1.class, ArtifactDownloader.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodN(1.class, ArtifactDownloader.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, ArtifactDownloader.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, ArtifactDownloader.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(1.class, ArtifactDownloader.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(1.class, ArtifactDownloader.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != 1.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        @Generated
        @Internal
        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        @Generated
        @Internal
        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        @Generated
        @Internal
        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }
    }

    static class DownloadAction
    implements Callable<File>,
    GroovyObject {
        private boolean offlineMode;
        private String description;
        private File distDir;
        private File markerFile;
        private File localDownloadedFile;
        private URI downloadURI;
        private URI distributionUrl;
        private ArtifactRootVerification verifyArtifactRoot;
        private RequiresDownload requiresDownload;
        private Downloader downloadInstance;
        private CheckSumVerification verifyDownloadChecksum;
        private ArtifactUnpacker unpacker;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;

        @Generated
        public DownloadAction() {
            MetaClass metaClass;
            this.metaClass = metaClass = this.$getStaticMetaClass();
        }

        @Override
        public File call() throws Exception {
            if (this.distDir.isDirectory() && this.markerFile.isFile()) {
                return this.verifyArtifactRoot.verify(this.distDir);
            }
            if (this.requiresDownload.download(this.downloadURI, this.localDownloadedFile)) {
                if (this.offlineMode && ScriptBytecodeAdapter.compareNotEqual((Object)this.distributionUrl.getScheme(), (Object)"file")) {
                    throw (Throwable)new DistributionFailedException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.description}, new String[]{"Cannot download ", " as currently offline"})));
                }
                File tmpDownloadedFile = new File(this.localDownloadedFile.getParentFile(), ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.localDownloadedFile.getName()}, new String[]{"", ".part"})));
                tmpDownloadedFile.delete();
                this.downloadInstance.getProgressLogger().log(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{UriUtils.safeUri(this.distributionUrl)}, new String[]{"Downloading ", ""})));
                this.downloadInstance.getDownloader().download(this.distributionUrl, tmpDownloadedFile);
                tmpDownloadedFile.renameTo(this.localDownloadedFile);
            }
            List<File> topLevelDirs = FileUtils.listDirs(this.distDir);
            File dir = null;
            Iterator<File> iterator = topLevelDirs.iterator();
            while (iterator.hasNext()) {
                dir = (File)ScriptBytecodeAdapter.castToType((Object)iterator.next(), File.class);
                this.downloadInstance.getProgressLogger().log(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{dir.getAbsolutePath()}, new String[]{"Deleting directory ", ""})));
                ResourceGroovyMethods.deleteDir((File)dir);
            }
            if (DefaultTypeTransformation.booleanUnbox((Object)this.verifyDownloadChecksum)) {
                this.verifyDownloadChecksum.verify(this.localDownloadedFile);
            }
            if (DefaultTypeTransformation.booleanUnbox((Object)this.unpacker)) {
                this.downloadInstance.getProgressLogger().log(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.localDownloadedFile.getAbsolutePath(), this.distDir.getAbsolutePath()}, new String[]{"Unpacking ", " to ", ""})));
                this.unpacker.unpack(this.localDownloadedFile, this.distDir);
            }
            File root = DefaultTypeTransformation.booleanUnbox((Object)this.verifyArtifactRoot) ? this.verifyArtifactRoot.verify(this.distDir) : this.distDir;
            this.markerFile.createNewFile();
            return root;
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != DownloadAction.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodN(DownloadAction.class, ArtifactDownloader.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodN(DownloadAction.class, ArtifactDownloader.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, ArtifactDownloader.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, ArtifactDownloader.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(DownloadAction.class, ArtifactDownloader.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(DownloadAction.class, ArtifactDownloader.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        @Generated
        @Internal
        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        @Generated
        @Internal
        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        @Generated
        @Internal
        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }

        @Generated
        public boolean getOfflineMode() {
            return this.offlineMode;
        }

        @Generated
        public boolean isOfflineMode() {
            return this.offlineMode;
        }

        @Generated
        public void setOfflineMode(boolean bl) {
            this.offlineMode = bl;
        }

        @Generated
        public String getDescription() {
            return this.description;
        }

        @Generated
        public void setDescription(String string) {
            this.description = string;
        }

        @Generated
        public File getDistDir() {
            return this.distDir;
        }

        @Generated
        public void setDistDir(File file) {
            this.distDir = file;
        }

        @Generated
        public File getMarkerFile() {
            return this.markerFile;
        }

        @Generated
        public void setMarkerFile(File file) {
            this.markerFile = file;
        }

        @Generated
        public File getLocalDownloadedFile() {
            return this.localDownloadedFile;
        }

        @Generated
        public void setLocalDownloadedFile(File file) {
            this.localDownloadedFile = file;
        }

        @Generated
        public URI getDownloadURI() {
            return this.downloadURI;
        }

        @Generated
        public void setDownloadURI(URI uRI) {
            this.downloadURI = uRI;
        }

        @Generated
        public URI getDistributionUrl() {
            return this.distributionUrl;
        }

        @Generated
        public void setDistributionUrl(URI uRI) {
            this.distributionUrl = uRI;
        }

        @Generated
        public ArtifactRootVerification getVerifyArtifactRoot() {
            return this.verifyArtifactRoot;
        }

        @Generated
        public void setVerifyArtifactRoot(ArtifactRootVerification artifactRootVerification) {
            this.verifyArtifactRoot = artifactRootVerification;
        }

        @Generated
        public RequiresDownload getRequiresDownload() {
            return this.requiresDownload;
        }

        @Generated
        public void setRequiresDownload(RequiresDownload requiresDownload) {
            this.requiresDownload = requiresDownload;
        }

        @Generated
        public Downloader getDownloadInstance() {
            return this.downloadInstance;
        }

        @Generated
        public void setDownloadInstance(Downloader downloader) {
            this.downloadInstance = downloader;
        }

        @Generated
        public CheckSumVerification getVerifyDownloadChecksum() {
            return this.verifyDownloadChecksum;
        }

        @Generated
        public void setVerifyDownloadChecksum(CheckSumVerification checkSumVerification) {
            this.verifyDownloadChecksum = checkSumVerification;
        }

        @Generated
        public ArtifactUnpacker getUnpacker() {
            return this.unpacker;
        }

        @Generated
        public void setUnpacker(ArtifactUnpacker artifactUnpacker) {
            this.unpacker = artifactUnpacker;
        }
    }
}

