/*
 * Decompiled with CFR 0.152.
 */
package org.ysb33r.grolifant.api.v4.exec;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskAction;
import org.gradle.process.ExecResult;
import org.gradle.process.ExecSpec;
import org.ysb33r.grolifant.api.core.ProjectOperations;
import org.ysb33r.grolifant.api.errors.ExecutionException;
import org.ysb33r.grolifant.api.v4.MapUtils;
import org.ysb33r.grolifant.api.v4.StringUtils;
import org.ysb33r.grolifant.api.v4.exec.AbstractExecSpec;
import org.ysb33r.grolifant.api.v4.exec.AbstractToolExecSpec;

@Deprecated
public abstract class AbstractExecTask<B extends AbstractExecTask, T extends AbstractToolExecSpec>
extends DefaultTask {
    protected final ProjectOperations projectOperations;
    private T execSpec;
    private ExecResult execResult;
    private boolean ignoreExitValue = false;
    private InputStream standardInput;
    private OutputStream standardOutput;
    private OutputStream errorOutput;
    private Object workingDir;
    private Object exe;
    private final List<Object> args = new ArrayList<Object>();
    private final Map<String, Object> env = new TreeMap<String, Object>();

    public B setIgnoreExitValue(boolean flag) {
        this.ignoreExitValue = flag;
        return (B)((Object)this);
    }

    public B ignoreExitValue(boolean flag) {
        this.ignoreExitValue = flag;
        return (B)((Object)this);
    }

    @Input
    public boolean isIgnoreExitValue() {
        return this.ignoreExitValue;
    }

    public B setStandardInput(InputStream inputStream) {
        this.standardInput = inputStream;
        return (B)((Object)this);
    }

    public B standardInput(InputStream inputStream) {
        return this.setStandardInput(inputStream);
    }

    @Internal
    public InputStream getStandardInput() {
        return this.standardInput;
    }

    public B setStandardOutput(OutputStream outputStream) {
        this.standardOutput = outputStream;
        return (B)((Object)this);
    }

    public B standardOutput(OutputStream outputStream) {
        return this.setStandardOutput(outputStream);
    }

    @Internal
    public OutputStream getStandardOutput() {
        return this.standardOutput;
    }

    public B setErrorOutput(OutputStream outputStream) {
        this.errorOutput = outputStream;
        return (B)((Object)this);
    }

    public B errorOutput(OutputStream outputStream) {
        return this.setErrorOutput(outputStream);
    }

    @Internal
    public OutputStream getErrorOutput() {
        return this.errorOutput;
    }

    @Internal
    public File getWorkingDir() {
        return this.getProject().file(this.workingDir);
    }

    public void setWorkingDir(Object workDir) {
        this.workingDir = workDir;
    }

    public B workingDir(Object workDir) {
        this.workingDir = workDir;
        return (B)((Object)this);
    }

    @Internal
    public Map<String, Object> getEnvironment() {
        return this.env;
    }

    public void setEnvironment(Map<String, ?> map) {
        this.env.clear();
        this.env.putAll(map);
    }

    public B environment(Map<String, ?> map) {
        this.env.putAll(map);
        return (B)((Object)this);
    }

    public B environment(String envVar, Object value) {
        this.env.put(envVar, value);
        return (B)((Object)this);
    }

    @Optional
    @Input
    public String getExecutable() {
        return StringUtils.stringize(this.exe);
    }

    @Internal
    public List<String> getCommandLine() {
        return this.execSpec != null ? ((AbstractToolExecSpec)this.execSpec).getCommandLine() : new ArrayList();
    }

    public void setExeArgs(Iterable<?> args) {
        this.args.clear();
        for (Object i : args) {
            this.args.add(i);
        }
    }

    public void exeArgs(Iterable<?> args) {
        for (Object i : args) {
            this.args.add(i);
        }
    }

    public void exeArgs(Object ... args) {
        for (Object i : args) {
            this.args.add(i);
        }
    }

    @Optional
    @Input
    public List<String> getExeArgs() {
        return StringUtils.stringize(this.args);
    }

    @Internal
    public ExecResult getExecResult() {
        return this.execResult;
    }

    @TaskAction
    public void exec() {
        this.createAndSetExecSpec();
        Action runner = toSpec -> ((AbstractToolExecSpec)this.execSpec).copyToExecSpec((ExecSpec)toSpec);
        try {
            this.execResult = this.projectOperations.exec(runner);
        }
        catch (Exception e) {
            throw new ExecutionException("Failure in running external process", (Throwable)e);
        }
    }

    protected AbstractExecTask() {
        this.getEnvironment().clear();
        this.getEnvironment().putAll(System.getenv());
        this.projectOperations = ProjectOperations.create((Project)this.getProject());
    }

    protected void setToolExecutable(Object exe) {
        this.exe = exe;
    }

    @Internal
    protected T getExecSpec() {
        return this.execSpec;
    }

    protected void createAndSetExecSpec() {
        this.execSpec = this.createExecSpec();
    }

    protected T configureExecSpec() {
        ((AbstractExecSpec)this.execSpec).setIgnoreExitValue(this.ignoreExitValue);
        ((AbstractExecSpec)this.execSpec).environment(MapUtils.stringizeValues(this.env));
        ((AbstractToolExecSpec)this.execSpec).exeArgs(this.getExeArgs());
        if (this.standardInput != null) {
            ((AbstractExecSpec)this.execSpec).setStandardInput(this.standardInput);
        }
        if (this.standardOutput != null) {
            ((AbstractExecSpec)this.execSpec).setStandardOutput(this.standardOutput);
        }
        if (this.errorOutput != null) {
            ((AbstractExecSpec)this.execSpec).setErrorOutput(this.errorOutput);
        }
        if (this.workingDir != null) {
            ((AbstractExecSpec)this.execSpec).workingDir(this.workingDir);
        }
        if (this.exe != null) {
            ((AbstractToolExecSpec)this.execSpec).executable(StringUtils.stringize(this.exe));
        }
        return this.execSpec;
    }

    protected abstract T createExecSpec();
}

