/*
 * Decompiled with CFR 0.152.
 */
package org.ysb33r.grolifant.api.v4.runnable;

import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.TaskAction;
import org.gradle.process.ExecResult;
import org.gradle.process.ProcessForkOptions;
import org.ysb33r.grolifant.api.core.ProjectOperations;
import org.ysb33r.grolifant.api.v4.MapUtils;
import org.ysb33r.grolifant.api.v4.runnable.ExecutableExecSpec;

public abstract class AbstractExecWrapperTask<E extends ExecutableExecSpec<E>>
extends DefaultTask {
    private final ProjectOperations projectOperations;
    private final Map<String, Object> env = new LinkedHashMap<String, Object>();
    private final Provider<Map<String, String>> envProvider;

    public void setEnvironment(Map<String, ?> args) {
        this.env.clear();
        this.env.putAll(args);
    }

    @Input
    public Provider<Map<String, String>> getEnvironmentProvider() {
        return this.envProvider;
    }

    public void environment(Map<String, ?> args) {
        this.env.putAll(args);
    }

    @TaskAction
    protected void exec() {
        E execSpec = this.createExecSpec();
        this.addExecutableToExecSpec(execSpec);
        this.addEnvironmentToExecSpec(execSpec);
        this.configureExecSpec(execSpec);
        this.runExecSpec(execSpec);
    }

    protected AbstractExecWrapperTask() {
        this.projectOperations = ProjectOperations.find((Project)this.getProject());
        this.envProvider = this.getProject().provider(() -> MapUtils.stringizeValues(this.env));
    }

    protected abstract E createExecSpec();

    @Internal
    protected abstract File getExecutableLocation();

    protected abstract void configureExecSpec(E var1);

    @Internal
    protected ProjectOperations getProjectOperations() {
        return this.projectOperations;
    }

    protected void addExecutableToExecSpec(E execSpec) {
        execSpec.executable(this.getExecutableLocation().getAbsolutePath());
    }

    protected void addEnvironmentToExecSpec(E execSpec) {
        execSpec.environment((Map)this.getEnvironmentProvider().get());
    }

    protected ExecResult runExecSpec(E execSpec) {
        return this.projectOperations.exec(target -> {
            ExecutableExecSpec cfr_ignored_0 = (ExecutableExecSpec)execSpec.copyTo((ProcessForkOptions)target);
        });
    }
}

