/*
 * ============================================================================
 * (C) Copyright Schalk W. Cronje 2016 - 2023
 *
 * This software is licensed under the Apache License 2.0
 * See http://www.apache.org/licenses/LICENSE-2.0 for license details
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 * ============================================================================
 */
package org.ysb33r.grolifant.internal.v5.executable

import groovy.transform.CompileStatic
import org.gradle.process.ExecSpec
import org.ysb33r.grolifant.api.core.ProjectOperations
import org.ysb33r.grolifant.api.core.executable.AppRunnerSpec
import org.ysb33r.grolifant.internal.core.runnable.AbstractAppRunnerSpec
import org.ysb33r.grolifant.internal.core.runnable.EnvironmentVariableProviders

/**
 * Implementation of an {@link AppRunnerSpec} for Gradle 5.0 - 6.9.
 *
 * @author Schalk W. Cronjé
 *
 * @since 2.0
 */
@CompileStatic
class InternalAppRunnerSpec extends AbstractAppRunnerSpec implements AppRunnerSpec {

    InternalAppRunnerSpec(ProjectOperations po) {
        super(
            po,
            { ExecSpec es, EnvironmentVariableProviders ep -> new InternalEntryPointProxy(po, es, ep) }
        )
    }
}
