/*
 * ============================================================================
 * (C) Copyright Schalk W. Cronje 2016 - 2023
 *
 * This software is licensed under the Apache License 2.0
 * See http://www.apache.org/licenses/LICENSE-2.0 for license details
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 * ============================================================================
 */
package org.ysb33r.grolifant.internal.v5.jvm

import groovy.transform.CompileStatic
import org.gradle.api.provider.Property
import org.gradle.api.provider.Provider
import org.gradle.process.JavaForkOptions
import org.ysb33r.grolifant.api.core.jvm.JvmDebugOptions

/**
 *
 * Proxies between {@link JvmDebugOptions} and Gradle's {@link org.gradle.process.JavaDebugOptions}.
 *
 * @author Schalk W. Cronjé
 *
 * @since 2.0
 */
@CompileStatic
class JvmDebugOptionsProxy {

    void copyDebugOptions(JvmDebugOptions src, JavaForkOptions target) {
        target.debugOptions.identity {
            update(src.enabled, it.enabled)
            update(src.server, it.server)
            update(src.suspend, it.suspend)
            updatePort(src.port, it.port)
        }
    }

    private void update(Provider<Boolean> src, Property<Boolean> target) {
        if (src.present) {
            target.set(src)
        }
    }

    private void updatePort(Provider<Integer> src, Property<Integer> target) {
        if (src.present) {
            target.set(src)
        }
    }
}
