/*
 * ============================================================================
 * (C) Copyright Schalk W. Cronje 2016 - 2023
 *
 * This software is licensed under the Apache License 2.0
 * See http://www.apache.org/licenses/LICENSE-2.0 for license details
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 * ============================================================================
 */
package org.ysb33r.grolifant.internal.v5.jvm

import groovy.transform.CompileStatic
import org.gradle.api.Action
import org.gradle.api.model.ObjectFactory
import org.gradle.api.provider.Property
import org.gradle.process.JavaDebugOptions
import org.gradle.process.JavaExecSpec
import org.ysb33r.grolifant.api.core.ProjectOperations
import org.ysb33r.grolifant.internal.v4.jvm.Pre56FakeJavaExecSpec

@CompileStatic
class Pre60FakeJavaExecSpec extends Pre56FakeJavaExecSpec {

    Pre60FakeJavaExecSpec(ProjectOperations po, ObjectFactory objects) {
        super(po)
        debugOptions = new JavaDebugOptions() {
            final Property<Boolean> enabled = objects.property(Boolean)
            final Property<Integer> port = objects.property(Integer)
            final Property<Boolean> server = objects.property(Boolean)
            final Property<Boolean> suspend = objects.property(Boolean)
        }

        debugOptions.identity {
            enabled.set(false)
            port.set(5050)
            server.set(false)
            suspend.set(false)
        }
    }

    @Override
    JavaExecSpec copyTo(JavaExecSpec target) {
        super.copyTo(target)
        me()
    }

    JavaDebugOptions getDebugOptions() {
        this.debugOptions
    }

    void debugOptions(Action<JavaDebugOptions> action) {
        action.execute(this.debugOptions)
    }

    private final JavaDebugOptions debugOptions
}
