/*
 * ============================================================================
 * (C) Copyright Schalk W. Cronje 2016 - 2023
 *
 * This software is licensed under the Apache License 2.0
 * See http://www.apache.org/licenses/LICENSE-2.0 for license details
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 * ============================================================================
 */
package org.ysb33r.grolifant.loadable.v5

import groovy.transform.CompileStatic
import org.gradle.api.Project
import org.gradle.api.provider.Provider
import org.ysb33r.grolifant.api.core.ProjectOperations
import org.ysb33r.grolifant.loadable.core.ProjectToolsProxy

/**
 * Project tools for Gradle 5.x.
 *
 * @since 2.0
 */
@CompileStatic
class DefaultProjectTools extends ProjectToolsProxy {

    DefaultProjectTools(ProjectOperations po, Project project) {
        super(po, project)
        this.projectGroup = project.provider { -> po.stringTools.stringize(project.group ?: unspecifiedProjectGroup) }
        if (!(project.version instanceof GradleProjectVersion)) {
            def tmp = project.version
            updateVersion(project.provider { ->
                po.stringTools.stringize(tmp ?: unspecifiedProjectVersion)
            })
        }
    }

    /**
     * Lazy-evaluated project group.
     *
     * @return provider to project group
     */
    @Override
    Provider<String> getGroupProvider() {
        this.projectGroup
    }

    private final Provider<String> projectGroup
}
