/*
 * ============================================================================
 * (C) Copyright Schalk W. Cronje 2016 - 2023
 *
 * This software is licensed under the Apache License 2.0
 * See http://www.apache.org/licenses/LICENSE-2.0 for license details
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 * ============================================================================
 */
package org.ysb33r.grolifant.loadable.v5

import groovy.transform.CompileDynamic
import groovy.transform.CompileStatic
import org.gradle.api.Project
import org.gradle.api.artifacts.repositories.AuthenticationContainer
import org.gradle.internal.reflect.DirectInstantiator
import org.ysb33r.grolifant.api.core.LegacyLevel
import org.ysb33r.grolifant.api.core.ProjectOperations
import org.ysb33r.grolifant.api.core.RepositoryTools

/**
 * Providers repository tools that is compatible with Gradle 4.x
 *
 * @author Schalk W. Cronjé
 *
 * @since 2.0
 */
@CompileStatic
class DefaultRepositoryTools implements RepositoryTools {
    @SuppressWarnings('UnusedMethodParameter')
    DefaultRepositoryTools(ProjectOperations incompleteReference, Project project) {
    }

    /**
     * Creates an instance of an {@link AuthenticationContainer}
     *
     * @return Authentication container that is usable with a repository.
     */
    @Override
    AuthenticationContainer authenticationContainer() {
        createAuthenticationContainer()
    }

    @CompileDynamic
    @SuppressWarnings('UnnecessaryPackageReference')
    static private AuthenticationContainer createAuthenticationContainer() {
        if (LegacyLevel.PRE_5_1) {
            new org.gradle.internal.authentication.DefaultAuthenticationContainer(DirectInstantiator.INSTANCE)
        } else {
            // I'm sorry, this is ugly, but this a way to load the API change in Gradle 5.1, but still keep backwards
            // compatibility to older Gradle versions.
            // If https://github.com/gradle/gradle/issues/729 is implemented we can fix this issue.
            Class decorator = DefaultRepositoryTools.classLoader.loadClass(
                'org.gradle.api.internal.CollectionCallbackActionDecorator'
            )
            new org.gradle.internal.authentication.DefaultAuthenticationContainer(
                DirectInstantiator.INSTANCE,
                decorator.NOOP
            )
        }
    }
}
