/*
 * Decompiled with CFR 0.152.
 */
package org.ysb33r.grolifant.internal.v7.jvm.worker;

import org.gradle.workers.WorkQueue;
import org.gradle.workers.WorkerExecutor;
import org.ysb33r.grolifant.api.core.jvm.worker.WorkerAppParameterFactory;
import org.ysb33r.grolifant.api.core.jvm.worker.WorkerExecSpec;
import org.ysb33r.grolifant.api.core.jvm.worker.WorkerIsolation;
import org.ysb33r.grolifant.api.core.jvm.worker.WorkerPromise;
import org.ysb33r.grolifant.api.remote.worker.SerializableWorkerAppParameters;
import org.ysb33r.grolifant.api.remote.worker.WorkerAppExecutor;
import org.ysb33r.grolifant.api.remote.worker.WorkerAppExecutorFactory;
import org.ysb33r.grolifant.internal.v7.jvm.worker.InternalWorkerAppExecutor;

public class WorkerSubmission<P extends SerializableWorkerAppParameters> {
    public WorkerPromise toWorkQueue(WorkerIsolation isolationMode, WorkerExecutor worker, WorkerExecSpec workerExecSpec, WorkerAppExecutorFactory<P> workerAppExecutorFactory, WorkerAppParameterFactory<P> parameterFactory) {
        SerializableWorkerAppParameters exeParams = parameterFactory.createAndConfigure(workerExecSpec);
        WorkerAppExecutor executor = workerAppExecutorFactory.createExecutor();
        WorkQueue wq = this.workQueue(isolationMode, worker, workerExecSpec);
        wq.submit(InternalWorkerAppExecutor.class, p -> {
            p.getParams().set((Object)exeParams);
            p.getExecutor().set((Object)executor);
        });
        return () -> wq.await();
    }

    private WorkQueue workQueue(WorkerIsolation isolationMode, WorkerExecutor worker, WorkerExecSpec workerExecSpec) {
        if (isolationMode.equals((Object)WorkerIsolation.CLASSPATH)) {
            return worker.classLoaderIsolation(spec -> spec.getClasspath().from(new Object[]{workerExecSpec.getJavaExecSpec().getClasspath()}));
        }
        return worker.processIsolation(spec -> {
            spec.getClasspath().from(new Object[]{workerExecSpec.getJavaExecSpec().getClasspath()});
            workerExecSpec.getJavaExecSpec().copyTo(spec.getForkOptions());
        });
    }
}

