/*
 * Decompiled with CFR 0.152.
 */
package org.yuanheng.cookcc.maven;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.repository.RepositorySystem;
import org.codehaus.plexus.compiler.Compiler;
import org.codehaus.plexus.compiler.CompilerConfiguration;
import org.codehaus.plexus.compiler.manager.CompilerManager;
import org.codehaus.plexus.compiler.manager.NoSuchCompilerException;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.yuanheng.cookcc.maven.Task;
import org.yuanheng.cookcc.maven.TaskFactory;

@Mojo(name="run")
public class CookCCMojo
extends AbstractMojo {
    public static final String PROCESSOR = "org.yuanheng.cookcc.input.ap.CookCCProcessor";
    @Component
    private CompilerManager compilerManager;
    @Parameter(property="maven.compiler.compilerId", defaultValue="javac")
    private String compilerId;
    @Parameter(property="maven.compiler.compilerVersion")
    private String compilerVersion;
    @Parameter(defaultValue="${project.compileSourceRoots}", readonly=true, required=true)
    private List<String> compileSourceRoots;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    private MavenSession session;
    @Component
    private RepositorySystem repositorySystem;
    @Parameter(property="source", defaultValue="1.8")
    private String source;
    @Parameter(property="target", defaultValue="1.8")
    private String target;
    @Parameter(property="verbose")
    private boolean verbose;
    @Parameter
    private PlexusConfiguration tasks;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject m_project;

    private CompilerConfiguration createBaseCompilerConfig(String cookccPath) throws MojoExecutionException {
        CompilerConfiguration config = new CompilerConfiguration();
        String classDir = this.m_project.getBuild().getOutputDirectory();
        config.setOutputLocation(classDir);
        config.setSourceVersion(this.source);
        config.setTargetVersion(this.target);
        config.addCompilerCustomArgument("-Xlint:-options", null);
        config.setWorkingDirectory(new File(classDir));
        config.setProc("only");
        config.setAnnotationProcessors(new String[]{PROCESSOR});
        config.addClasspathEntry(cookccPath);
        config.addClasspathEntry(classDir);
        String src = this.getJavaSrcDir();
        if (src == null) {
            throw new MojoExecutionException("Unable to locate Java source directory.");
        }
        config.addSourceLocation(src);
        config.addCompilerCustomArgument("-Ad=" + this.compileSourceRoots.get(0), null);
        config.setFork(true);
        config.setVerbose(this.verbose);
        return config;
    }

    public String getJavaSrcDir() {
        String suffix = File.separatorChar + "java";
        for (String src : this.compileSourceRoots) {
            if (!src.endsWith(suffix)) continue;
            return src;
        }
        return null;
    }

    public void execute() throws MojoExecutionException {
        Compiler compiler;
        try {
            compiler = this.compilerManager.getCompiler(this.compilerId);
        }
        catch (NoSuchCompilerException ex) {
            throw new MojoExecutionException("no compiler found", (Exception)((Object)ex));
        }
        Dependency cookccDependency = null;
        for (Dependency dependency : this.m_project.getDependencies()) {
            if (!"cookcc".equals(dependency.getArtifactId()) || !"org.yuanheng.cookcc".equals(dependency.getGroupId())) continue;
            if ("0.3.3".equals(dependency.getVersion())) {
                throw new MojoExecutionException("CookCC version needs to be 0.4.0 and later.");
            }
            cookccDependency = dependency;
            break;
        }
        if (cookccDependency == null) {
            throw new MojoExecutionException("No cookcc dependency found.");
        }
        Artifact artifact = this.repositorySystem.createDependencyArtifact(cookccDependency);
        this.session.getLocalRepository().find(artifact);
        File cookccJar = artifact.getFile();
        String cookccPath = null;
        if (cookccJar != null && cookccJar.isFile()) {
            try {
                cookccPath = cookccJar.getCanonicalPath();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (cookccPath == null) {
            throw new MojoExecutionException("Unable to locate CookCC jar.");
        }
        if (this.tasks == null || this.tasks.getChildCount() == 0) {
            throw new MojoExecutionException("No CookCC tasks.");
        }
        PlexusConfiguration[] children = this.tasks.getChildren();
        Log log = this.getLog();
        for (PlexusConfiguration child : children) {
            if (!"task".equals(child.getName())) continue;
            Task t = TaskFactory.getTask(child);
            t.execute(log, compiler, this.createBaseCompilerConfig(cookccPath), this.getJavaSrcDir(), cookccPath);
        }
    }
}

