/*
 * Decompiled with CFR 0.152.
 */
package org.yuanheng.cookcc.maven;

import java.io.File;
import java.util.HashSet;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.plexus.compiler.Compiler;
import org.codehaus.plexus.compiler.CompilerConfiguration;
import org.codehaus.plexus.compiler.CompilerException;
import org.codehaus.plexus.compiler.CompilerMessage;
import org.codehaus.plexus.compiler.CompilerResult;
import org.yuanheng.cookcc.maven.Option;
import org.yuanheng.cookcc.maven.Task;

class JavacTask
implements Task {
    private String m_src;
    private Option[] m_options;

    JavacTask(String src, Option[] options) {
        this.m_src = src;
        this.m_options = options;
    }

    @Override
    public void execute(Log log, Compiler compiler, CompilerConfiguration config, String javaSrcDir, String cookccPath) throws MojoExecutionException {
        File file = new File(this.m_src);
        if (!file.isFile()) {
            throw new MojoExecutionException("File " + this.m_src + " does not exist.");
        }
        try {
            for (Option option : this.m_options) {
                if (option.arg == null) {
                    config.addCompilerCustomArgument("-A" + option.opt, null);
                    continue;
                }
                config.addCompilerCustomArgument("-A" + option.opt + "=" + option.arg, null);
            }
            HashSet<File> set = new HashSet<File>();
            this.m_src.replace('/', File.separatorChar);
            log.info((CharSequence)("CookCC is processing " + this.m_src));
            set.add(new File(this.m_src));
            config.setSourceFiles(set);
            String[] args = compiler.createCommandLine(config);
            String msg = "javac";
            for (String arg : args) {
                msg = msg + " " + arg;
            }
            log.debug((CharSequence)msg);
            log.debug((CharSequence)("Using compiler: " + compiler.getClass()));
            CompilerResult compilerResult = compiler.performCompile(config);
            log.debug((CharSequence)("Success: " + compilerResult.isSuccess()));
            boolean hasError = false;
            StringBuilder errorMessages = new StringBuilder();
            errorMessages.append("CookCC reported an error.  Please use mvn -X clean cookcc:run to display the full javac command to execute cookcc and reproduce the error message.\n");
            log.debug((CharSequence)("CompilerMessages: " + compilerResult.getCompilerMessages().size()));
            block8: for (CompilerMessage message : compilerResult.getCompilerMessages()) {
                CompilerMessage.Kind kind = message.getKind();
                switch (kind) {
                    case WARNING: {
                        log.warn((CharSequence)message.toString());
                        continue block8;
                    }
                    case ERROR: {
                        log.error((CharSequence)message.toString());
                        errorMessages.append(message.getMessage()).append('\n');
                        hasError = true;
                        continue block8;
                    }
                }
                log.info((CharSequence)(kind + ": " + message.toString()));
            }
            if (hasError || !compilerResult.isSuccess()) {
                throw new MojoExecutionException(errorMessages.toString());
            }
        }
        catch (CompilerException ex) {
            throw new MojoExecutionException("Error compiling code", (Exception)((Object)ex));
        }
    }
}

