/*
 * Decompiled with CFR 0.152.
 */
package org.yuanheng.cookcc.maven;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.plexus.compiler.Compiler;
import org.codehaus.plexus.compiler.CompilerConfiguration;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.yuanheng.cookcc.maven.Option;
import org.yuanheng.cookcc.maven.Task;

class XccTask
implements Task {
    private String m_src;
    private Option[] m_options;

    XccTask(String src, Option[] options) {
        this.m_src = src;
        this.m_options = options;
    }

    @Override
    public void execute(Log log, Compiler compiler, CompilerConfiguration config, String javaSrcDir, String cookccPath) throws MojoExecutionException {
        File file = new File(this.m_src);
        if (!file.isFile()) {
            throw new MojoExecutionException("File " + this.m_src + " does not exist.");
        }
        ArrayList<String> arguments = new ArrayList<String>();
        for (Option option : this.m_options) {
            arguments.add("-" + option.opt);
            if (option.arg == null) continue;
            arguments.add(option.arg);
        }
        arguments.add("-d");
        arguments.add(javaSrcDir);
        arguments.add(this.m_src);
        String[] args = arguments.toArray(new String[arguments.size()]);
        String msg = "java -jar " + cookccPath;
        for (String arg : arguments) {
            msg = msg + " " + arg;
        }
        log.debug((CharSequence)msg);
        File cookccJar = new File(cookccPath);
        if (!cookccJar.exists()) {
            throw new MojoExecutionException("Failed to load " + cookccPath);
        }
        URLClassLoader cl = null;
        try {
            cl = new URLClassLoader(new URL[]{cookccJar.toURI().toURL()});
            Class<?> c = cl.loadClass("org.yuanheng.cookcc.Main");
            Method method = c.getMethod("main", String[].class);
            method.invoke(null, new Object[]{args});
        }
        catch (Exception ex) {
            try {
                if (cl != null) {
                    cl.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw new MojoExecutionException("Error executing CookCC", ex);
        }
        try {
            cl.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static boolean getBoolean(PlexusConfiguration xml, String attr) {
        return "true".equals(xml.getAttribute(attr));
    }

    public static XccTask getTask(PlexusConfiguration taskXml) throws MojoExecutionException {
        String str;
        String src = taskXml.getAttribute("src");
        if (src == null) {
            throw new MojoExecutionException("Missing src attribute.");
        }
        ArrayList<Option> options = new ArrayList<Option>();
        if (XccTask.getBoolean(taskXml, "debug")) {
            options.add(new Option("-Adebug", null));
        }
        if (XccTask.getBoolean(taskXml, "defaultReduce")) {
            options.add(new Option("-Adefaultreduce", null));
        }
        if (XccTask.getBoolean(taskXml, "lexerAnalysis")) {
            options.add(new Option("-Alexeranalysis", null));
        }
        if (XccTask.getBoolean(taskXml, "analysis")) {
            options.add(new Option("-Aanalysis", null));
        }
        if ((str = taskXml.getAttribute("lexerTable")) != null) {
            options.add(new Option("-Alexertable", str));
        }
        if ((str = taskXml.getAttribute("parserTable")) != null) {
            options.add(new Option("-Aparsertable", str));
        }
        if (src.endsWith(".java")) {
            if (XccTask.getBoolean(taskXml, "public")) {
                options.add(new Option("-Apublic", null));
            }
            if (XccTask.getBoolean(taskXml, "abstract")) {
                options.add(new Option("-Aabstract", null));
            }
            if ((str = taskXml.getAttribute("extend")) != null) {
                options.add(new Option("-Aextend=" + str, null));
            }
        }
        if (taskXml.getChildCount() > 0) {
            for (PlexusConfiguration optionXml : taskXml.getChildren()) {
                if (!"option".equals(optionXml.getName())) {
                    throw new MojoExecutionException("Unknown tag: " + optionXml.getName());
                }
                String name = optionXml.getAttribute("name");
                if (name == null) {
                    throw new MojoExecutionException("<option> tag missing name attribute.");
                }
                if (!name.startsWith("-")) {
                    throw new MojoExecutionException("Invalid option: " + name);
                }
                String value = optionXml.getAttribute("value");
                options.add(new Option("-A" + name.substring(1) + "=" + value, null));
            }
        }
        return new XccTask(src, options.toArray(new Option[options.size()]));
    }
}

