/*
 * Decompiled with CFR 0.152.
 */
package org.yupana.akka;

import com.google.protobuf.ByteString;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import java.io.Serializable;
import org.yupana.api.query.Result;
import org.yupana.api.types.DataType;
import org.yupana.core.QueryEngineRouter;
import org.yupana.core.sql.parser.NumericValue;
import org.yupana.core.sql.parser.StringValue;
import org.yupana.core.sql.parser.TimestampValue$;
import org.yupana.proto.BatchSqlQuery;
import org.yupana.proto.Ping;
import org.yupana.proto.Pong;
import org.yupana.proto.Response;
import org.yupana.proto.ResultChunk;
import org.yupana.proto.ResultField;
import org.yupana.proto.ResultHeader;
import org.yupana.proto.ResultStatistics;
import org.yupana.proto.SqlQuery;
import org.yupana.proto.Value;
import org.yupana.proto.Version;
import org.yupana.proto.util.ProtocolVersion$;
import scala.;
import scala.$less$colon$less$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Either;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0005b\u0001\u0002\u0005\n\u0001AA\u0001\"\t\u0001\u0003\u0002\u0003\u0006IA\t\u0005\u0006Q\u0001!\t!\u000b\u0005\u0006[\u0001!\tA\f\u0005\u0006;\u0002!\tA\u0018\u0005\u0006M\u0002!\ta\u001a\u0005\u0006m\u0002!Ia\u001e\u0005\b\u0003\u000b\u0001A\u0011BA\u0004\u00059\u0011V-];fgRD\u0015M\u001c3mKJT!AC\u0006\u0002\t\u0005\\7.\u0019\u0006\u0003\u00195\ta!_;qC:\f'\"\u0001\b\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001\tr\u0003\u0005\u0002\u0013+5\t1CC\u0001\u0015\u0003\u0015\u00198-\u00197b\u0013\t12C\u0001\u0004B]f\u0014VM\u001a\t\u00031}i\u0011!\u0007\u0006\u00035m\tAb]2bY\u0006dwnZ4j]\u001eT!\u0001H\u000f\u0002\u0011QL\b/Z:bM\u0016T\u0011AH\u0001\u0004G>l\u0017B\u0001\u0011\u001a\u00055\u0019FO]5di2{wmZ5oO\u0006\t\u0012/^3ss\u0016sw-\u001b8f%>,H/\u001a:\u0011\u0005\r2S\"\u0001\u0013\u000b\u0005\u0015Z\u0011\u0001B2pe\u0016L!a\n\u0013\u0003#E+XM]=F]\u001eLg.\u001a*pkR,'/\u0001\u0004=S:LGO\u0010\u000b\u0003U1\u0002\"a\u000b\u0001\u000e\u0003%AQ!\t\u0002A\u0002\t\n1\u0002[1oI2,\u0017+^3ssR\u0011q\u0006\u0017\u000b\u0003aM\u00032!\r\u001b7\u001b\u0005\u0011$BA\u001a\u0014\u0003)\u0019wN\\2veJ,g\u000e^\u0005\u0003kI\u0012aAR;ukJ,\u0007\u0003B\u001c@\u0005*s!\u0001O\u001f\u000f\u0005ebT\"\u0001\u001e\u000b\u0005mz\u0011A\u0002\u001fs_>$h(C\u0001\u0015\u0013\tq4#A\u0004qC\u000e\\\u0017mZ3\n\u0005\u0001\u000b%AB#ji\",'O\u0003\u0002?'A\u00111i\u0012\b\u0003\t\u0016\u0003\"!O\n\n\u0005\u0019\u001b\u0012A\u0002)sK\u0012,g-\u0003\u0002I\u0013\n11\u000b\u001e:j]\u001eT!AR\n\u0011\u0007]ZU*\u0003\u0002M\u0003\nA\u0011\n^3sCR|'\u000f\u0005\u0002O#6\tqJ\u0003\u0002Q\u0017\u0005)\u0001O]8u_&\u0011!k\u0014\u0002\t%\u0016\u001c\bo\u001c8tK\")Ak\u0001a\u0002+\u0006\u0011Qm\u0019\t\u0003cYK!a\u0016\u001a\u0003!\u0015CXmY;uS>t7i\u001c8uKb$\b\"B-\u0004\u0001\u0004Q\u0016\u0001C:rYF+XM]=\u0011\u00059[\u0016B\u0001/P\u0005!\u0019\u0016\u000f\\)vKJL\u0018\u0001\u00055b]\u0012dWMQ1uG\"\fV/\u001a:z)\ty\u0016\r\u0006\u00021A\")A\u000b\u0002a\u0002+\")!\r\u0002a\u0001G\u0006i!-\u0019;dQN\u000bH.U;fef\u0004\"A\u00143\n\u0005\u0015|%!\u0004\"bi\u000eD7+\u001d7Rk\u0016\u0014\u00180A\biC:$G.\u001a)j]\u001e\u0004&o\u001c;p)\u00151\u0004.\u001c:u\u0011\u0015IW\u00011\u0001k\u0003\u0011\u0001\u0018N\\4\u0011\u00059[\u0017B\u00017P\u0005\u0011\u0001\u0016N\\4\t\u000b9,\u0001\u0019A8\u0002\u00195\f'n\u001c:WKJ\u001c\u0018n\u001c8\u0011\u0005I\u0001\u0018BA9\u0014\u0005\rIe\u000e\u001e\u0005\u0006g\u0016\u0001\ra\\\u0001\r[&twN\u001d,feNLwN\u001c\u0005\u0006k\u0016\u0001\rAQ\u0001\bm\u0016\u00148/[8o\u00035\u0011Xm];miR{\u0007K]8u_R\u0011!\n\u001f\u0005\u0006s\u001a\u0001\rA_\u0001\u0007e\u0016\u001cX\u000f\u001c;\u0011\u0007m\f\t!D\u0001}\u0015\tih0A\u0003rk\u0016\u0014\u0018P\u0003\u0002\u0000\u0017\u0005\u0019\u0011\r]5\n\u0007\u0005\rAP\u0001\u0004SKN,H\u000e^\u0001\rG>tg/\u001a:u-\u0006dW/\u001a\u000b\u0005\u0003\u0013\tI\u0002\u0005\u0003\u0002\f\u0005UQBAA\u0007\u0015\u0011\ty!!\u0005\u0002\rA\f'o]3s\u0015\r\t\u0019\u0002J\u0001\u0004gFd\u0017\u0002BA\f\u0003\u001b\u0011QAV1mk\u0016Dq!a\u0007\b\u0001\u0004\ti\"A\u0003wC2,X\rE\u0002O\u0003?I1!a\u0006P\u0001")
public class RequestHandler
implements StrictLogging {
    private final QueryEngineRouter queryEngineRouter;
    private Logger logger;

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public Future<Either<String, Iterator<Response>>> handleQuery(SqlQuery sqlQuery, ExecutionContext ec) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Processing SQL query: \"{}\"; parameters: {}", new Object[]{sqlQuery.sql(), sqlQuery.parameters()});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return Future$.MODULE$.apply((Function0 & Serializable)() -> {
            Map params = ((IterableOnceOps)sqlQuery.parameters().map((Function1 & Serializable)p -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)p.index())), (Object)this.convertValue(p.value())))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
            return $this.queryEngineRouter.query(sqlQuery.sql(), params).map((Function1 & Serializable)result -> this.resultToProto((Result)result));
        }, ec);
    }

    public Future<Either<String, Iterator<Response>>> handleBatchQuery(BatchSqlQuery batchSqlQuery, ExecutionContext ec) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Processing batch SQL {} with {}", new Object[]{batchSqlQuery.sql(), BoxesRunTime.boxToInteger((int)batchSqlQuery.batch().size())});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return Future$.MODULE$.apply((Function0 & Serializable)() -> {
            Seq params = (Seq)batchSqlQuery.batch().map((Function1 & Serializable)ps -> ((IterableOnceOps)ps.parameters().map((Function1 & Serializable)p -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)p.index())), (Object)this.convertValue(p.value())))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
            return $this.queryEngineRouter.batchQuery(batchSqlQuery.sql(), params).map((Function1 & Serializable)result -> this.resultToProto((Result)result));
        }, ec);
    }

    public Either<String, Iterator<Response>> handlePingProto(Ping ping, int majorVersion, int minorVersion, String version) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Processing Ping request: {}", (Object)ping);
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        if (ping.getVersion().protocol() != ProtocolVersion$.MODULE$.value()) {
            BoxedUnit boxedUnit2;
            if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error("Incompatible protocols: driver protocol {}, server protocol {}", new Object[]{BoxesRunTime.boxToInteger((int)ping.getVersion().protocol()), BoxesRunTime.boxToInteger((int)ProtocolVersion$.MODULE$.value())});
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            return package$.MODULE$.Left().apply((Object)new StringBuilder(58).append("Incompatible protocols: driver protocol ").append(ping.getVersion().protocol()).append(", server protocol ").append(ProtocolVersion$.MODULE$.value()).toString());
        }
        Pong pong = new Pong(ping.reqTime(), System.currentTimeMillis(), (Option)new Some((Object)new Version(ProtocolVersion$.MODULE$.value(), majorVersion, minorVersion, version)));
        return package$.MODULE$.Right().apply((Object)package$.MODULE$.Iterator().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Response[]{new Response((Response.Resp)new Response.Resp$.Pong(pong))})));
    }

    private Iterator<Response> resultToProto(Result result) {
        BoxedUnit boxedUnit;
        Seq rts = (Seq)result.dataTypes().zipWithIndex();
        Iterator results = result.map((Function1 & Serializable)row -> {
            Seq bytes = (Seq)rts.map((Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    DataType rt = (DataType)tuple2._1();
                    int idx = tuple2._2$mcI$sp();
                    Object v = row.get(idx);
                    byte[] b = v != null ? rt.storable().write(v) : (byte[])Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte());
                    return ByteString.copyFrom((byte[])b);
                }
                throw new MatchError((Object)tuple2);
            });
            return new Response((Response.Resp)new Response.Resp$.Result(new ResultChunk(bytes)));
        });
        Seq resultFields = (Seq)((IterableOps)result.fieldNames().zip((IterableOnce)result.dataTypes())).map((Function1 & Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                String name = (String)tuple2._1();
                DataType rt = (DataType)tuple2._2();
                return new ResultField(name, rt.meta().sqlTypeName());
            }
            throw new MatchError((Object)tuple2);
        });
        Response header = new Response((Response.Resp)new Response.Resp$.ResultHeader(new ResultHeader(resultFields, (Option)new Some((Object)result.name()))));
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug(new StringBuilder(17).append("Response header: ").append(header).toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Response footer = new Response((Response.Resp)new Response.Resp$.ResultStatistics(new ResultStatistics(-1, -1)));
        return package$.MODULE$.Iterator().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Response[]{header})).$plus$plus((Function0 & Serializable)() -> results).$plus$plus((Function0 & Serializable)() -> package$.MODULE$.Iterator().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Response[]{footer})));
    }

    private org.yupana.core.sql.parser.Value convertValue(Value value) {
        Value.Value value2 = value.value();
        if (value2 instanceof Value.Value$.TextValue) {
            Value.Value$.TextValue textValue = (Value.Value$.TextValue)value2;
            String s = textValue.value();
            return new StringValue(s);
        }
        if (value2 instanceof Value.Value$.DecimalValue) {
            Value.Value$.DecimalValue decimalValue = (Value.Value$.DecimalValue)value2;
            String n = decimalValue.value();
            return new NumericValue(package$.MODULE$.BigDecimal().apply(n));
        }
        if (value2 instanceof Value.Value$.TimeValue) {
            Value.Value$.TimeValue timeValue = (Value.Value$.TimeValue)value2;
            long t = timeValue.value();
            return TimestampValue$.MODULE$.apply(t);
        }
        if (Value.Value$.Empty$.MODULE$.equals(value2)) {
            throw new IllegalArgumentException("Empty value");
        }
        throw new MatchError((Object)value2);
    }

    public RequestHandler(QueryEngineRouter queryEngineRouter) {
        this.queryEngineRouter = queryEngineRouter;
        StrictLogging.$init$((StrictLogging)this);
        Statics.releaseFence();
    }
}

