/*
 * Decompiled with CFR 0.152.
 */
package org.yupana.api.types;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.joda.time.Period;
import org.joda.time.ReadablePeriod;
import org.joda.time.format.ISOPeriodFormat;
import org.joda.time.format.PeriodFormatter;
import org.yupana.api.Blob;
import org.yupana.api.Time;
import org.yupana.api.types.Storable;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Serializable;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.math.BigDecimal$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.RichInt$;

public final class Storable$
implements Serializable {
    public static final Storable$ MODULE$;
    private final PeriodFormatter org$yupana$api$types$Storable$$periodFormat;
    private final Storable<Object> booleanStorable;
    private final Storable<Object> doubleStorable;
    private final Storable<scala.math.BigDecimal> bigDecimalStorable;
    private final Storable<Object> byteStorable;
    private final Storable<Object> shortStorable;
    private final Storable<Object> intStorable;
    private final Storable<Object> longStorable;
    private final Storable<String> stringStorable;
    private final Storable<Time> timestampStorable;
    private final Storable<Period> periodStorable;
    private final Storable<Blob> blobStorable;

    static {
        new Storable$();
    }

    public PeriodFormatter org$yupana$api$types$Storable$$periodFormat() {
        return this.org$yupana$api$types$Storable$$periodFormat;
    }

    public Storable<Object> booleanStorable() {
        return this.booleanStorable;
    }

    public Storable<Object> doubleStorable() {
        return this.doubleStorable;
    }

    public Storable<scala.math.BigDecimal> bigDecimalStorable() {
        return this.bigDecimalStorable;
    }

    public Storable<Object> byteStorable() {
        return this.byteStorable;
    }

    public Storable<Object> shortStorable() {
        return this.shortStorable;
    }

    public Storable<Object> intStorable() {
        return this.intStorable;
    }

    public Storable<Object> longStorable() {
        return this.longStorable;
    }

    public Storable<String> stringStorable() {
        return this.stringStorable;
    }

    public Storable<Time> timestampStorable() {
        return this.timestampStorable;
    }

    public Storable<Period> periodStorable() {
        return this.periodStorable;
    }

    public Storable<Blob> blobStorable() {
        return this.blobStorable;
    }

    public <T> Storable<Seq<T>> seqStorable(Storable<T> rt, ClassTag<T> ct) {
        return this.of((Function1<ByteBuffer, T>)new Serializable(rt, ct){
            public static final long serialVersionUID = 0L;
            private final Storable rt$1;
            private final ClassTag ct$1;

            public final Seq<T> apply(ByteBuffer bb) {
                return Storable$.MODULE$.org$yupana$api$types$Storable$$readSeq(this.rt$1, bb, this.ct$1);
            }
            {
                this.rt$1 = rt$1;
                this.ct$1 = ct$1;
            }
        }, (Function1<T, byte[]>)new Serializable(rt){
            public static final long serialVersionUID = 0L;
            private final Storable rt$1;

            public final byte[] apply(Seq<T> array) {
                return Storable$.MODULE$.org$yupana$api$types$Storable$$seqToBytes(this.rt$1, array);
            }
            {
                this.rt$1 = rt$1;
            }
        });
    }

    public <T> Storable<T> of(Function1<ByteBuffer, T> r, Function1<T, byte[]> w) {
        return new Storable<T>(r, w){
            private final Function1 r$1;
            private final Function1 w$1;

            public T read(byte[] a) {
                return (T)this.r$1.apply((Object)ByteBuffer.wrap(a));
            }

            public T read(ByteBuffer b) {
                return (T)this.r$1.apply((Object)b);
            }

            public byte[] write(T t) {
                return (byte[])this.w$1.apply(t);
            }
            {
                this.r$1 = r$1;
                this.w$1 = w$1;
            }
        };
    }

    public <T> Storable<T> noop() {
        return new Storable<T>(){

            public T read(byte[] a) {
                throw new IllegalStateException("This should not be read");
            }

            public T read(ByteBuffer b) {
                throw new IllegalStateException("This should not be read");
            }

            public byte[] write(T t) {
                throw new IllegalStateException("This should not be written");
            }
        };
    }

    public <T, U> Storable<U> wrap(Storable<T> storable, Function1<T, U> from, Function1<U, T> to) {
        return new Storable<U>(storable, from, to){
            private final Storable storable$1;
            private final Function1 from$1;
            private final Function1 to$1;

            public U read(byte[] a) {
                return (U)this.from$1.apply(this.storable$1.read(a));
            }

            public U read(ByteBuffer bb) {
                return (U)this.from$1.apply(this.storable$1.read(bb));
            }

            public byte[] write(U t) {
                return this.storable$1.write(this.to$1.apply(t));
            }
            {
                this.storable$1 = storable$1;
                this.from$1 = from$1;
                this.to$1 = to$1;
            }
        };
    }

    public BigDecimal org$yupana$api$types$Storable$$readBigDecimal(ByteBuffer bb) {
        int scale = this.org$yupana$api$types$Storable$$readVInt(bb);
        int size = this.org$yupana$api$types$Storable$$readVInt(bb);
        byte[] bytes = (byte[])Array$.MODULE$.ofDim(size, ClassTag$.MODULE$.Byte());
        bb.get(bytes);
        return new BigDecimal(new BigInteger(bytes), scale);
    }

    public String org$yupana$api$types$Storable$$readString(ByteBuffer bb) {
        int length = bb.getInt();
        byte[] bytes = (byte[])Array$.MODULE$.ofDim(length, ClassTag$.MODULE$.Byte());
        bb.get(bytes);
        return new String(bytes, StandardCharsets.UTF_8);
    }

    public short org$yupana$api$types$Storable$$readVShort(ByteBuffer bb) {
        long l = this.org$yupana$api$types$Storable$$readVLong(bb);
        if (l <= (long)Short.MAX_VALUE && l >= (long)Short.MIN_VALUE) {
            return (short)l;
        }
        throw new IllegalArgumentException("Got Long but Short expected");
    }

    public int org$yupana$api$types$Storable$$readVInt(ByteBuffer bb) {
        long l = this.org$yupana$api$types$Storable$$readVLong(bb);
        if (l <= Integer.MAX_VALUE && l >= Integer.MIN_VALUE) {
            return (int)l;
        }
        throw new IllegalArgumentException("Got Long but Int expected");
    }

    public long org$yupana$api$types$Storable$$readVLong(ByteBuffer bb) {
        long l;
        byte first = bb.get();
        int len = first >= -112 ? 1 : (first >= -120 ? -111 - first : -119 - first);
        LongRef result = LongRef.create((long)0L);
        if (len == 1) {
            l = first;
        } else {
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), len - 1).foreach$mVc$sp((Function1)new Serializable(bb, result){
                public static final long serialVersionUID = 0L;
                private final ByteBuffer bb$1;
                private final LongRef result$1;

                public final void apply(int x$6) {
                    this.apply$mcVI$sp(x$6);
                }

                public void apply$mcVI$sp(int x$6) {
                    byte b = this.bb$1.get();
                    this.result$1.elem <<= 8;
                    this.result$1.elem |= (long)(b & 0xFF);
                }
                {
                    this.bb$1 = bb$1;
                    this.result$1 = result$1;
                }
            });
            l = first >= -120 ? result.elem : result.elem ^ 0xFFFFFFFFFFFFFFFFL;
        }
        return l;
    }

    public <T> Seq<T> org$yupana$api$types$Storable$$readSeq(Storable<T> storable, ByteBuffer bb, ClassTag<T> evidence$1) {
        int size = this.org$yupana$api$types$Storable$$readVInt(bb);
        ListBuffer result = (ListBuffer)ListBuffer$.MODULE$.empty();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), size).foreach((Function1)new Serializable(storable, bb, result){
            public static final long serialVersionUID = 0L;
            private final Storable storable$2;
            private final ByteBuffer bb$2;
            private final ListBuffer result$2;

            public final ListBuffer<T> apply(int _) {
                return this.result$2.$plus$eq(this.storable$2.read(this.bb$2));
            }
            {
                this.storable$2 = storable$2;
                this.bb$2 = bb$2;
                this.result$2 = result$2;
            }
        });
        return result;
    }

    public byte[] org$yupana$api$types$Storable$$bigDecimalToBytes(scala.math.BigDecimal x) {
        BigDecimal u = x.underlying();
        byte[] a = u.unscaledValue().toByteArray();
        byte[] scale = this.org$yupana$api$types$Storable$$vLongToBytes(u.scale());
        byte[] length = this.org$yupana$api$types$Storable$$vLongToBytes(a.length);
        return ByteBuffer.allocate(a.length + scale.length + length.length).put(scale).put(length).put(a).array();
    }

    public byte[] org$yupana$api$types$Storable$$stringToBytes(String s) {
        byte[] a = s.getBytes(StandardCharsets.UTF_8);
        return ByteBuffer.allocate(a.length + 4).putInt(a.length).put(a).array();
    }

    public byte[] org$yupana$api$types$Storable$$vLongToBytes(long l) {
        byte[] byArray;
        if (l <= 127L && l > -112L) {
            byte[] byArray2 = new byte[1];
            byArray = byArray2;
            byArray2[0] = (byte)l;
        } else {
            LongRef ll = LongRef.create((long)l);
            ByteBuffer bb = ByteBuffer.allocate(9);
            int len = -112;
            if (ll.elem < 0L) {
                len = -120;
                ll.elem ^= 0xFFFFFFFFFFFFFFFFL;
            }
            long tmp = ll.elem;
            while (tmp != 0L) {
                tmp >>= 8;
                --len;
            }
            bb.put((byte)len);
            len = len < -120 ? -(len + 120) : -(len + 112);
            RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(len - 1), 0).by(-1).foreach((Function1)new Serializable(ll, bb){
                public static final long serialVersionUID = 0L;
                private final LongRef ll$1;
                private final ByteBuffer bb$3;

                public final ByteBuffer apply(int idx) {
                    int shift = idx * 8;
                    long mask = 255L << shift;
                    return this.bb$3.put((byte)((this.ll$1.elem & mask) >> shift));
                }
                {
                    this.ll$1 = ll$1;
                    this.bb$3 = bb$3;
                }
            });
            byte[] res = new byte[bb.position()];
            bb.rewind();
            bb.get(res);
            byArray = res;
        }
        return byArray;
    }

    public <T> byte[] org$yupana$api$types$Storable$$seqToBytes(Storable<T> storable, Seq<T> array) {
        Seq bytes = (Seq)array.map((Function1)new Serializable(storable){
            public static final long serialVersionUID = 0L;
            private final Storable storable$3;

            public final byte[] apply(T t) {
                return this.storable$3.write(t);
            }
            {
                this.storable$3 = storable$3;
            }
        }, Seq$.MODULE$.canBuildFrom());
        byte[] arraySize = this.org$yupana$api$types$Storable$$vLongToBytes(array.length());
        int resultSize = BoxesRunTime.unboxToInt((Object)bytes.foldLeft((Object)BoxesRunTime.boxToInteger((int)arraySize.length), (Function2)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(int a, byte[] i) {
                return a + i.length;
            }
        }));
        ByteBuffer bb = ByteBuffer.allocate(resultSize);
        bb.put(arraySize);
        bytes.foreach((Function1)new Serializable(bb){
            public static final long serialVersionUID = 0L;
            private final ByteBuffer bb$4;

            public final ByteBuffer apply(byte[] x$1) {
                return this.bb$4.put(x$1);
            }
            {
                this.bb$4 = bb$4;
            }
        });
        return bb.array();
    }

    public Blob org$yupana$api$types$Storable$$readBlob(ByteBuffer bb) {
        int size = this.org$yupana$api$types$Storable$$readVInt(bb);
        byte[] data = new byte[size];
        bb.get(data);
        return new Blob(data);
    }

    public byte[] org$yupana$api$types$Storable$$blobToBytes(Blob blob) {
        byte[] sizeBytes = this.org$yupana$api$types$Storable$$vLongToBytes(blob.bytes().length);
        return (byte[])Predef$.MODULE$.byteArrayOps(sizeBytes).$plus$plus((GenTraversableOnce)Predef$.MODULE$.byteArrayOps(blob.bytes()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Byte()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private Storable$() {
        MODULE$ = this;
        this.org$yupana$api$types$Storable$$periodFormat = ISOPeriodFormat.standard();
        this.booleanStorable = this.of((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(ByteBuffer x$1) {
                return x$1.get() != 0;
            }
        }, (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final byte[] apply(boolean x) {
                return (byte[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{x ? (byte)1 : 0}), ClassTag$.MODULE$.Byte());
            }
        });
        this.doubleStorable = this.of((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(ByteBuffer x$2) {
                return x$2.getDouble();
            }
        }, (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final byte[] apply(double d) {
                return ByteBuffer.allocate(8).putDouble(d).array();
            }
        });
        this.bigDecimalStorable = this.of((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final scala.math.BigDecimal apply(ByteBuffer bb) {
                return BigDecimal$.MODULE$.javaBigDecimal2bigDecimal(Storable$.MODULE$.org$yupana$api$types$Storable$$readBigDecimal(bb));
            }
        }, (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final byte[] apply(scala.math.BigDecimal x) {
                return Storable$.MODULE$.org$yupana$api$types$Storable$$bigDecimalToBytes(x);
            }
        });
        this.byteStorable = this.of((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final byte apply(ByteBuffer x$3) {
                return x$3.get();
            }
        }, (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final byte[] apply(byte x$4) {
                return new byte[]{x$4};
            }
        });
        this.shortStorable = this.of((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final short apply(ByteBuffer bb) {
                return Storable$.MODULE$.org$yupana$api$types$Storable$$readVShort(bb);
            }
        }, (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final byte[] apply(short s) {
                return Storable$.MODULE$.org$yupana$api$types$Storable$$vLongToBytes(s);
            }
        });
        this.intStorable = this.of((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(ByteBuffer bb) {
                return Storable$.MODULE$.org$yupana$api$types$Storable$$readVInt(bb);
            }
        }, (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final byte[] apply(int i) {
                return Storable$.MODULE$.org$yupana$api$types$Storable$$vLongToBytes(i);
            }
        });
        this.longStorable = this.of((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final long apply(ByteBuffer bb) {
                return Storable$.MODULE$.org$yupana$api$types$Storable$$readVLong(bb);
            }
        }, (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final byte[] apply(long l) {
                return Storable$.MODULE$.org$yupana$api$types$Storable$$vLongToBytes(l);
            }
        });
        this.stringStorable = this.of((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(ByteBuffer bb) {
                return Storable$.MODULE$.org$yupana$api$types$Storable$$readString(bb);
            }
        }, (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final byte[] apply(String s) {
                return Storable$.MODULE$.org$yupana$api$types$Storable$$stringToBytes(s);
            }
        });
        this.timestampStorable = this.wrap(this.longStorable(), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Time apply(long l) {
                return new Time(l);
            }
        }, (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final long apply(Time x$5) {
                return x$5.millis();
            }
        });
        this.periodStorable = this.wrap(this.stringStorable(), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Period apply(String s) {
                return ISOPeriodFormat.standard().parsePeriod(s);
            }
        }, (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Period p) {
                return Storable$.MODULE$.org$yupana$api$types$Storable$$periodFormat().print((ReadablePeriod)p);
            }
        });
        this.blobStorable = this.of((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Blob apply(ByteBuffer bb) {
                return Storable$.MODULE$.org$yupana$api$types$Storable$$readBlob(bb);
            }
        }, (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final byte[] apply(Blob blob) {
                return Storable$.MODULE$.org$yupana$api$types$Storable$$blobToBytes(blob);
            }
        });
    }
}

