/*
 * Decompiled with CFR 0.152.
 */
package org.yupana.ehcache;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import java.io.Serializable;
import java.time.Duration;
import javax.cache.CacheManager;
import javax.cache.Caching;
import javax.cache.spi.CachingProvider;
import org.ehcache.config.Builder;
import org.ehcache.config.CacheConfiguration;
import org.ehcache.config.ResourceUnit;
import org.ehcache.config.builders.CacheConfigurationBuilder;
import org.ehcache.config.builders.ExpiryPolicyBuilder;
import org.ehcache.config.builders.ResourcePoolsBuilder;
import org.ehcache.config.units.EntryUnit;
import org.ehcache.config.units.MemoryUnit;
import org.ehcache.expiry.ExpiryPolicy;
import org.ehcache.jsr107.Eh107Configuration;
import org.ehcache.jsr107.EhcacheCachingProvider;
import org.yupana.core.cache.Cache;
import org.yupana.core.cache.CacheDescription;
import org.yupana.core.cache.CacheFactory;
import org.yupana.core.cache.CacheFactory$;
import org.yupana.core.cache.JCache;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005eb\u0001\u0002\t\u0012\u0001aAQ!\r\u0001\u0005\u0002IBq!\u000e\u0001A\u0002\u0013%a\u0007C\u0004B\u0001\u0001\u0007I\u0011\u0002\"\t\r!\u0003\u0001\u0015)\u00038\u0011\u001dI\u0005\u00011A\u0005\n)CqA\u0016\u0001A\u0002\u0013%q\u000b\u0003\u0004Z\u0001\u0001\u0006Ka\u0013\u0005\b5\u0002\u0011\r\u0011\"\u0011\\\u0011\u00199\u0007\u0001)A\u00059\")\u0001\u000e\u0001C!S\")q\u000f\u0001C!q\")a\u0010\u0001C!\u007f\"1\u0011\u0011\u0001\u0001\u0005\u0012}Dq!a\u0001\u0001\t\u0013\t)\u0001C\u0004\u0002\u001e\u0001!I!a\b\u0003\u001d\u0015C7)Y2iK\u001a\u000b7\r^8ss*\u0011!cE\u0001\bK\"\u001c\u0017m\u00195f\u0015\t!R#\u0001\u0004zkB\fg.\u0019\u0006\u0002-\u0005\u0019qN]4\u0004\u0001M!\u0001!G\u0010(!\tQR$D\u0001\u001c\u0015\u0005a\u0012!B:dC2\f\u0017B\u0001\u0010\u001c\u0005\u0019\te.\u001f*fMB\u0011\u0001%J\u0007\u0002C)\u0011!eI\u0001\u0006G\u0006\u001c\u0007.\u001a\u0006\u0003IM\tAaY8sK&\u0011a%\t\u0002\r\u0007\u0006\u001c\u0007.\u001a$bGR|'/\u001f\t\u0003Q=j\u0011!\u000b\u0006\u0003U-\nAb]2bY\u0006dwnZ4j]\u001eT!\u0001L\u0017\u0002\u0011QL\b/Z:bM\u0016T\u0011AL\u0001\u0004G>l\u0017B\u0001\u0019*\u00055\u0019FO]5di2{wmZ5oO\u00061A(\u001b8jiz\"\u0012a\r\t\u0003i\u0001i\u0011!E\u0001\rG\u0006\u001c\u0007.Z'b]\u0006<WM]\u000b\u0002oA\u0019!\u0004\u000f\u001e\n\u0005eZ\"AB(qi&|g\u000e\u0005\u0002<\u007f5\tAH\u0003\u0002#{)\ta(A\u0003kCZ\f\u00070\u0003\u0002Ay\ta1)Y2iK6\u000bg.Y4fe\u0006\u00012-Y2iK6\u000bg.Y4fe~#S-\u001d\u000b\u0003\u0007\u001a\u0003\"A\u0007#\n\u0005\u0015[\"\u0001B+oSRDqaR\u0002\u0002\u0002\u0003\u0007q'A\u0002yIE\nQbY1dQ\u0016l\u0015M\\1hKJ\u0004\u0013AB2bG\",7/F\u0001L!\ra\u0015kU\u0007\u0002\u001b*\u0011ajT\u0001\nS6lW\u000f^1cY\u0016T!\u0001U\u000e\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002S\u001b\n\u00191+\u001a;\u0011\u0005\u0001\"\u0016BA+\"\u0005A\u0019\u0015m\u00195f\t\u0016\u001c8M]5qi&|g.\u0001\u0006dC\u000eDWm]0%KF$\"a\u0011-\t\u000f\u001d3\u0011\u0011!a\u0001\u0017\u000691-Y2iKN\u0004\u0013\u0001\u00028b[\u0016,\u0012\u0001\u0018\t\u0003;\u0012t!A\u00182\u0011\u0005}[R\"\u00011\u000b\u0005\u0005<\u0012A\u0002\u001fs_>$h(\u0003\u0002d7\u00051\u0001K]3eK\u001aL!!\u001a4\u0003\rM#(/\u001b8h\u0015\t\u00197$A\u0003oC6,\u0007%A\u0005j]&$8)Y2iKR\u0011!\u000e\u001d\t\u0005A-lG/\u0003\u0002mC\t)1)Y2iKB\u0011aN\u001d\b\u0003_Bd\u0001\u0001C\u0003r\u0015\u0001\u00071+A\u0006eKN\u001c'/\u001b9uS>t\u0017BA:U\u0005\rYU-\u001f\t\u0003]VL!A\u001e+\u0003\u000bY\u000bG.^3\u0002\u0011\u001d,GoQ1dQ\u0016$\"!\u001f?\u0011\t\u0001Z'0 \t\u0003wJt!a\u001c?\t\u000bE\\\u0001\u0019A*\u0011\u0005m,\u0018a\u00034mkND7)Y2iKN$\u0012aQ\u0001\fS:LG/T1oC\u001e,'/A\tde\u0016\fG/Z\"bG\",7i\u001c8gS\u001e$B!a\u0002\u0002\u001aAA\u0011\u0011BA\t\u0003+\tY\"\u0004\u0002\u0002\f)!\u0011QBA\b\u0003\u0019\u0019wN\u001c4jO*\u0011!#F\u0005\u0005\u0003'\tYA\u0001\nDC\u000eDWmQ8oM&<WO]1uS>t\u0007cAA\fe:\u0019q.!\u0007\t\u000bEt\u0001\u0019A*\u0011\u0007\u0005]Q/\u0001\nde\u0016\fG/\u001a*fg>,(oY3Q_>dG\u0003BA\u0011\u0003_\u0001BA\u0007\u001d\u0002$A!\u0011QEA\u0016\u001b\t\t9C\u0003\u0003\u0002*\u0005-\u0011\u0001\u00032vS2$WM]:\n\t\u00055\u0012q\u0005\u0002\u0015%\u0016\u001cx.\u001e:dKB{w\u000e\\:Ck&dG-\u001a:\t\u000f\u0005Er\u00021\u0001\u00024\u0005)\u0001O]8qgB)Q,!\u000e]9&\u0019\u0011q\u00074\u0003\u00075\u000b\u0007\u000f")
public class EhCacheFactory
implements CacheFactory,
StrictLogging {
    private Option<CacheManager> cacheManager;
    private Set<CacheDescription> caches;
    private final String name;
    private final Logger logger;
    private final long DEFAULT_TTL;

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public long DEFAULT_TTL() {
        return this.DEFAULT_TTL;
    }

    public void org$yupana$core$cache$CacheFactory$_setter_$DEFAULT_TTL_$eq(long x$1) {
        this.DEFAULT_TTL = x$1;
    }

    private Option<CacheManager> cacheManager() {
        return this.cacheManager;
    }

    private void cacheManager_$eq(Option<CacheManager> x$1) {
        this.cacheManager = x$1;
    }

    private Set<CacheDescription> caches() {
        return this.caches;
    }

    private void caches_$eq(Set<CacheDescription> x$1) {
        this.caches = x$1;
    }

    public String name() {
        return this.name;
    }

    public Cache<Object, Object> initCache(CacheDescription description) {
        JCache jCache;
        Option<CacheManager> option;
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Initializing cache {} in EhCache", new Object[]{description.fullName()});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        if (this.cacheManager().isEmpty()) {
            this.initManager();
        }
        if ((option = this.cacheManager()) instanceof Some) {
            Some some = (Some)option;
            CacheManager cm = (CacheManager)some.value();
            if (!this.caches().contains((Object)description)) {
                BoxedUnit boxedUnit2;
                if (this.logger().underlying().isInfoEnabled()) {
                    this.logger().underlying().info("Adding cache {}", new Object[]{description.fullName()});
                    boxedUnit2 = BoxedUnit.UNIT;
                } else {
                    boxedUnit2 = BoxedUnit.UNIT;
                }
                javax.cache.Cache cache = cm.createCache(description.fullName(), Eh107Configuration.fromEhcacheCacheConfiguration(this.createCacheConfig(description)));
                this.caches_$eq((Set<CacheDescription>)((Set)this.caches().$plus((Object)description)));
                jCache = new JCache(cache);
            } else {
                BoxedUnit boxedUnit3;
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug("Cache {} already exists, skipping", new Object[]{description.fullName()});
                    boxedUnit3 = BoxedUnit.UNIT;
                } else {
                    boxedUnit3 = BoxedUnit.UNIT;
                }
                jCache = this.getCache(description);
            }
        } else {
            if (None$.MODULE$.equals(option)) {
                throw new IllegalStateException("Cannot initialize EhCache manager");
            }
            throw new MatchError(option);
        }
        JCache jCache2 = jCache;
        return jCache2;
    }

    public Cache<Object, Object> getCache(CacheDescription description) {
        Option<CacheManager> option = this.cacheManager();
        if (!(option instanceof Some)) {
            if (None$.MODULE$.equals(option)) {
                throw new IllegalStateException("EhCache manager is not initialized yet");
            }
            throw new MatchError(option);
        }
        Some some = (Some)option;
        CacheManager cm = (CacheManager)some.value();
        JCache jCache = new JCache(cm.getCache(description.fullName()));
        return jCache;
    }

    public void flushCaches() {
        this.caches().foreach((Function1 & Serializable & scala.Serializable)d -> {
            EhCacheFactory.$anonfun$flushCaches$1(this, d);
            return BoxedUnit.UNIT;
        });
    }

    public void initManager() {
        block2: {
            BoxedUnit boxedUnit;
            if (!this.cacheManager().isEmpty()) break block2;
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Initializing EhCache cache manager");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            System.setProperty("javax.cache.spi.CachingProvider", EhcacheCachingProvider.class.getName());
            CachingProvider provider = Caching.getCachingProvider((String)EhcacheCachingProvider.class.getName());
            this.cacheManager_$eq((Option<CacheManager>)new Some((Object)provider.getCacheManager()));
        }
    }

    private CacheConfiguration<Object, Object> createCacheConfig(CacheDescription description) {
        ExpiryPolicy expiryPolicy;
        Map props = CacheFactory$.MODULE$.propsForPrefix(new StringBuilder(17).append("analytics.caches.").append(description.name()).toString());
        Map defaultProps = CacheFactory$.MODULE$.propsForPrefix("analytics.caches.default.ehcache");
        boolean eternal = new StringOps(Predef$.MODULE$.augmentString((String)props.getOrElse((Object)"eternal", (Function0 & Serializable & scala.Serializable)() -> "false"))).toBoolean();
        if (eternal) {
            expiryPolicy = ExpiryPolicyBuilder.noExpiration();
        } else {
            Duration ttl = Duration.ofSeconds(BoxesRunTime.unboxToLong((Object)props.get((Object)"timeToLive").orElse((Function0 & Serializable & scala.Serializable)() -> defaultProps.get((Object)"timeToLive")).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToLong((long)EhCacheFactory.$anonfun$createCacheConfig$3(x$1))).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> this.DEFAULT_TTL())));
            Duration tti = (Duration)props.get((Object)"timeToIdle").map((Function1 & Serializable & scala.Serializable)s -> Duration.ofSeconds(new StringOps(Predef$.MODULE$.augmentString(s)).toLong())).orNull(Predef$.MODULE$.$conforms());
            expiryPolicy = ExpiryPolicyBuilder.expiry().create(ttl).access(tti).update(ttl).build();
        }
        ExpiryPolicy expiry = expiryPolicy;
        ResourcePoolsBuilder resourcePoolsBuilder = (ResourcePoolsBuilder)this.createResourcePool((Map<String, String>)props).orElse((Function0 & Serializable & scala.Serializable)() -> this.createResourcePool((Map<String, String>)defaultProps)).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalArgumentException(new StringBuilder(30).append("Cache size is not defined for ").append(description.name()).toString());
        });
        CacheConfiguration conf = CacheConfigurationBuilder.newCacheConfigurationBuilder((Class)description.keyBoxing().clazz(), (Class)description.valueBoxing().clazz(), (Builder)resourcePoolsBuilder).withExpiry(expiry).build();
        return conf;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Option<ResourcePoolsBuilder> createResourcePool(Map<String, String> props) {
        Option elements = props.get((Object)"maxElements").map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToLong((long)EhCacheFactory.$anonfun$createResourcePool$1(x$2)));
        Option heapSize = props.get((Object)"heapSize").map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToLong((long)EhCacheFactory.$anonfun$createResourcePool$2(x$3)));
        Option offHeapSize = props.get((Object)"offHeapSize").map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToLong((long)EhCacheFactory.$anonfun$createResourcePool$3(x$4)));
        boolean bl = false;
        Option option = null;
        Option option2 = elements;
        if (option2 instanceof Some) {
            Some some = (Some)option2;
            long e = BoxesRunTime.unboxToLong((Object)some.value());
            return new Some((Object)ResourcePoolsBuilder.newResourcePoolsBuilder().heap(e, (ResourceUnit)EntryUnit.ENTRIES));
        }
        if (None$.MODULE$.equals(option2)) {
            bl = true;
            option = option2;
            if (heapSize.nonEmpty() || offHeapSize.nonEmpty()) {
                ResourcePoolsBuilder builder = ResourcePoolsBuilder.newResourcePoolsBuilder();
                ResourcePoolsBuilder withHeap = (ResourcePoolsBuilder)heapSize.map((Function1 & Serializable & scala.Serializable)b -> builder.heap(BoxesRunTime.unboxToLong((Object)b), (ResourceUnit)MemoryUnit.B)).getOrElse((Function0 & Serializable & scala.Serializable)() -> builder);
                return new Some(offHeapSize.map((Function1 & Serializable & scala.Serializable)b -> withHeap.offheap(BoxesRunTime.unboxToLong((Object)b), MemoryUnit.B)).getOrElse((Function0 & Serializable & scala.Serializable)() -> withHeap));
            }
        }
        if (!bl) throw new MatchError((Object)option2);
        return None$.MODULE$;
    }

    public static final /* synthetic */ void $anonfun$flushCaches$1(EhCacheFactory $this, CacheDescription d) {
        $this.getCache(d).removeAll();
    }

    public static final /* synthetic */ long $anonfun$createCacheConfig$3(String x$1) {
        return new StringOps(Predef$.MODULE$.augmentString(x$1)).toLong();
    }

    public static final /* synthetic */ long $anonfun$createResourcePool$1(String x$2) {
        return new StringOps(Predef$.MODULE$.augmentString(x$2)).toLong();
    }

    public static final /* synthetic */ long $anonfun$createResourcePool$2(String x$3) {
        return new StringOps(Predef$.MODULE$.augmentString(x$3)).toLong();
    }

    public static final /* synthetic */ long $anonfun$createResourcePool$3(String x$4) {
        return new StringOps(Predef$.MODULE$.augmentString(x$4)).toLong();
    }

    public EhCacheFactory() {
        CacheFactory.$init$((CacheFactory)this);
        StrictLogging.$init$((StrictLogging)this);
        this.cacheManager = None$.MODULE$;
        this.caches = Predef$.MODULE$.Set().empty();
        this.name = "EhCache";
    }
}

