/*
 * Decompiled with CFR 0.152.
 */
package org.yupana.spark;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import org.apache.spark.rdd.RDD;
import org.apache.spark.streaming.dstream.DStream;
import org.joda.time.DateTime;
import org.yupana.api.query.DataPoint;
import org.yupana.api.schema.Dimension;
import org.yupana.api.schema.Rollup;
import org.yupana.api.schema.Schema;
import org.yupana.api.schema.Table;
import org.yupana.core.dao.RollupMetaDao;
import org.yupana.core.model.UpdateInterval;
import org.yupana.hbase.HBaseUtils$;
import org.yupana.spark.DataPointRddFunctions;
import org.yupana.spark.DataPointStreamFunctions;
import org.yupana.spark.ETLFunctions$;
import org.yupana.spark.ETLFunctions$$anonfun$processTransactions$1$;
import org.yupana.spark.EtlContext;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class ETLFunctions$
implements StrictLogging {
    public static final ETLFunctions$ MODULE$;
    private final Logger logger;

    static {
        new ETLFunctions$();
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public void processTransactions(EtlContext context, Schema schema, RDD<DataPoint> dataPoints, boolean doInvalidateRollups) {
        dataPoints.foreachPartition((Function1)new Serializable(context, schema, doInvalidateRollups){
            public static final long serialVersionUID = 0L;
            public final EtlContext context$1;
            public final Schema schema$1;
            public final boolean doInvalidateRollups$1;

            public final void apply(Iterator<DataPoint> ls) {
                ls.sliding(5000, 5000).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.processTransactions.1 $outer;

                    public final void apply(Seq<DataPoint> batch) {
                        BoxedUnit boxedUnit;
                        List dps = batch.toList();
                        if (ETLFunctions$.MODULE$.logger().underlying().isTraceEnabled()) {
                            ETLFunctions$.MODULE$.logger().underlying().trace("Put {} datapoints", new Object[]{BoxesRunTime.boxToInteger((int)dps.size())});
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        this.$outer.context$1.tsdb().put((Seq)dps);
                        Map byTable = dps.groupBy((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Table apply(DataPoint x$1) {
                                return x$1.table();
                            }
                        });
                        if (this.$outer.doInvalidateRollups$1) {
                            byTable.foreach((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ anonfun$processTransactions$1$$anonfun$apply$1 $outer;

                                public final void apply(Tuple2<Table, List<DataPoint>> x0$1) {
                                    Tuple2<Table, List<DataPoint>> tuple2 = x0$1;
                                    if (tuple2 != null) {
                                        BoxedUnit boxedUnit;
                                        Table t = (Table)tuple2._1();
                                        List ps = (List)tuple2._2();
                                        if (this.$outer.org$yupana$spark$ETLFunctions$$anonfun$$anonfun$$$outer().schema$1.rollups().exists((Function1)new Serializable(this, t){
                                            public static final long serialVersionUID = 0L;
                                            private final Table t$1;

                                            public final boolean apply(Rollup x$2) {
                                                String string = x$2.fromTable().name();
                                                String string2 = this.t$1.name();
                                                return !(string != null ? !string.equals(string2) : string2 != null);
                                            }
                                            {
                                                this.t$1 = t$1;
                                            }
                                        })) {
                                            ETLFunctions$.MODULE$.invalidateRollups(this.$outer.org$yupana$spark$ETLFunctions$$anonfun$$anonfun$$$outer().context$1.rollupMetaDao(), (Seq<DataPoint>)ps, t);
                                            boxedUnit = BoxedUnit.UNIT;
                                        } else {
                                            boxedUnit = BoxedUnit.UNIT;
                                        }
                                        BoxedUnit boxedUnit2 = boxedUnit;
                                        return;
                                    }
                                    throw new MatchError(tuple2);
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                }
                            });
                        }
                    }

                    public /* synthetic */ anonfun.processTransactions.1 org$yupana$spark$ETLFunctions$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.context$1 = context$1;
                this.schema$1 = schema$1;
                this.doInvalidateRollups$1 = doInvalidateRollups$1;
            }
        });
    }

    public void invalidateRollups(RollupMetaDao rollupMetaDao2, Seq<DataPoint> dps, Table table) {
        rollupMetaDao2.getRollupSpecialField("etl", table).foreach((Function1)new Serializable(rollupMetaDao2, dps, table){
            public static final long serialVersionUID = 0L;
            private final RollupMetaDao rollupMetaDao$1;
            private final Seq dps$1;
            public final Table table$1;

            public final void apply(long etlObligatoryRecalc) {
                this.apply$mcVJ$sp(etlObligatoryRecalc);
            }

            public void apply$mcVJ$sp(long etlObligatoryRecalc) {
                Seq rollupStatuses = ((TraversableLike)this.dps$1.filter((Function1)new Serializable(this, etlObligatoryRecalc){
                    public static final long serialVersionUID = 0L;
                    private final long etlObligatoryRecalc$1;

                    public final boolean apply(DataPoint x$3) {
                        return x$3.time() < this.etlObligatoryRecalc$1;
                    }
                    {
                        this.etlObligatoryRecalc$1 = etlObligatoryRecalc$1;
                    }
                })).groupBy((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.invalidateRollups.1 $outer;

                    public final long apply(DataPoint dp) {
                        return HBaseUtils$.MODULE$.baseTime(dp.time(), this.$outer.table$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }).mapValues((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(Seq<DataPoint> dps) {
                        return ETLFunctions$.MODULE$.org$yupana$spark$ETLFunctions$$invalidationMark((DataPoint)dps.head());
                    }
                }).toSeq();
                this.rollupMetaDao$1.putRollupStatuses(rollupStatuses, this.table$1);
                DateTime now = DateTime.now();
                Seq invalidatedPeriods = (Seq)rollupStatuses.map((Function1)new Serializable(this, now){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.invalidateRollups.1 $outer;
                    private final DateTime now$1;

                    public final UpdateInterval apply(Tuple2<Object, String> x0$2) {
                        Tuple2<Object, String> tuple2 = x0$2;
                        if (tuple2 != null) {
                            long baseTime = tuple2._1$mcJ$sp();
                            UpdateInterval updateInterval = new UpdateInterval(new DateTime(baseTime), new DateTime(baseTime + this.$outer.table$1.rowTimeSpan()), this.now$1);
                            return updateInterval;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.now$1 = now$1;
                    }
                }, Seq$.MODULE$.canBuildFrom());
                this.rollupMetaDao$1.putUpdatesIntervals(this.table$1.name(), invalidatedPeriods);
            }
            {
                this.rollupMetaDao$1 = rollupMetaDao$1;
                this.dps$1 = dps$1;
                this.table$1 = table$1;
            }
        });
    }

    public String org$yupana$spark$ETLFunctions$$invalidationMark(DataPoint dataPoint) {
        return (String)dataPoint.dimensions().foldLeft((Object)((Object)BoxesRunTime.boxToLong((long)dataPoint.time())).toString(), (Function2)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(String x0$3, Tuple2<Dimension, Object> x1$1) {
                Tuple2 tuple2 = new Tuple2((Object)x0$3, x1$1);
                if (tuple2 != null) {
                    String acc = (String)tuple2._1();
                    Tuple2 tuple22 = (Tuple2)tuple2._2();
                    if (tuple22 != null) {
                        Object v = tuple22._2();
                        String string = new StringBuilder().append((Object)acc).append(v).toString();
                        return string;
                    }
                }
                throw new MatchError((Object)tuple2);
            }
        });
    }

    public DataPointStreamFunctions dStream2Functions(DStream<DataPoint> stream) {
        return new DataPointStreamFunctions(stream);
    }

    public DataPointRddFunctions rdd2Functions(RDD<DataPoint> rdd) {
        return new DataPointRddFunctions(rdd);
    }

    private ETLFunctions$() {
        MODULE$ = this;
        StrictLogging.class.$init$((StrictLogging)this);
    }
}

