/*
 * Decompiled with CFR 0.152.
 */
package org.yupana.spark;

import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.Serializable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.spark.Partition;
import org.yupana.hbase.HdfsFileUtils$;
import org.yupana.settings.Read$;
import org.yupana.settings.Settings;
import org.yupana.spark.PartitionStorable;
import org.yupana.spark.ProgressSaver;
import scala.Function1;
import scala.MatchError;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.io.Codec$;
import scala.io.Source$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Using;
import scala.util.Using$;

@ScalaSignature(bytes="\u0006\u0005m4A!\u0004\b\u0001+!AA\b\u0001B\u0001B\u0003%Q\b\u0003\u0005F\u0001\t\u0005\t\u0015!\u0003G\u0011!I\u0005A!A!\u0002\u0013Q\u0005\"B(\u0001\t\u0003\u0001\u0006bB+\u0001\u0005\u0004%IA\u0016\u0005\u0007=\u0002\u0001\u000b\u0011B,\t\u000f}\u0003!\u0019!C\u0005-\"1\u0001\r\u0001Q\u0001\n]CQ!\u0019\u0001\u0005B\tDQa\u001b\u0001\u0005B1DQa\u001c\u0001\u0005BADQ!\u001d\u0001\u0005\nI\u0014\u0011\u0003\u0013#G'B\u0013xn\u001a:fgN\u001c\u0016M^3s\u0015\ty\u0001#A\u0003ta\u0006\u00148N\u0003\u0002\u0012%\u00051\u00110\u001e9b]\u0006T\u0011aE\u0001\u0004_J<7\u0001A\u000b\u0003-\r\u001aB\u0001A\f\u001eaA\u0011\u0001dG\u0007\u00023)\t!$A\u0003tG\u0006d\u0017-\u0003\u0002\u001d3\t1\u0011I\\=SK\u001a\u00042AH\u0010\"\u001b\u0005q\u0011B\u0001\u0011\u000f\u00055\u0001&o\\4sKN\u001c8+\u0019<feB\u0011!e\t\u0007\u0001\t\u0015!\u0003A1\u0001&\u0005\u0005\u0001\u0016C\u0001\u0014*!\tAr%\u0003\u0002)3\t9aj\u001c;iS:<\u0007C\u0001\u0016/\u001b\u0005Y#BA\b-\u0015\ti##\u0001\u0004ba\u0006\u001c\u0007.Z\u0005\u0003_-\u0012\u0011\u0002U1si&$\u0018n\u001c8\u0011\u0005EJdB\u0001\u001a8\u001d\t\u0019d'D\u00015\u0015\t)D#\u0001\u0004=e>|GOP\u0005\u00025%\u0011\u0001(G\u0001\ba\u0006\u001c7.Y4f\u0013\tQ4H\u0001\u0007TKJL\u0017\r\\5{C\ndWM\u0003\u000293\u0005Aa-\u001b7f\u001d\u0006lW\r\u0005\u0002?\u0005:\u0011q\b\u0011\t\u0003geI!!Q\r\u0002\rA\u0013X\rZ3g\u0013\t\u0019EI\u0001\u0004TiJLgn\u001a\u0006\u0003\u0003f\t\u0011\u0003]1si&$\u0018n\u001c8Ti>\u0014\u0018M\u00197f!\rqr)I\u0005\u0003\u0011:\u0011\u0011\u0003U1si&$\u0018n\u001c8Ti>\u0014\u0018M\u00197f\u0003!\u0019X\r\u001e;j]\u001e\u001c\bCA&N\u001b\u0005a%BA%\u0011\u0013\tqEJ\u0001\u0005TKR$\u0018N\\4t\u0003\u0019a\u0014N\\5u}Q!\u0011KU*U!\rq\u0002!\t\u0005\u0006y\u0011\u0001\r!\u0010\u0005\u0006\u000b\u0012\u0001\rA\u0012\u0005\u0006\u0013\u0012\u0001\rAS\u0001\u0014C2d\u0007+\u0019:uSRLwN\\:IK\u0006$WM]\u000b\u0002/B\u0011\u0001,X\u0007\u00023*\u0011!lW\u0001\u0005Y\u0006twMC\u0001]\u0003\u0011Q\u0017M^1\n\u0005\rK\u0016\u0001F1mYB\u000b'\u000f^5uS>t7\u000fS3bI\u0016\u0014\b%A\rd_6\u0004H.\u001a;fIB\u000b'\u000f^5uS>t7\u000fS3bI\u0016\u0014\u0018AG2p[BdW\r^3e!\u0006\u0014H/\u001b;j_:\u001c\b*Z1eKJ\u0004\u0013aD<sSR,\u0007+\u0019:uSRLwN\\:\u0015\u0005\r4\u0007C\u0001\re\u0013\t)\u0017D\u0001\u0003V]&$\b\"B4\n\u0001\u0004A\u0017A\u00019t!\r\t\u0014.I\u0005\u0003Un\u00121aU3r\u000359(/\u001b;f!J|wM]3tgR\u00111-\u001c\u0005\u0006]*\u0001\r!I\u0001\u0002a\u0006q!/Z1e!\u0006\u0014H/\u001b;j_:\u001cX#\u00015\u00021\r\u0014X-\u0019;f\u0011\n\u000b7/Z\"p]\u001aLw-\u001e:bi&|g\u000eF\u0001t!\t!\u00180D\u0001v\u0015\t1x/\u0001\u0003d_:4'B\u0001=-\u0003\u0019A\u0017\rZ8pa&\u0011!0\u001e\u0002\u000e\u0007>tg-[4ve\u0006$\u0018n\u001c8")
public class HDFSProgressSaver<P extends Partition>
implements ProgressSaver<P>,
Serializable {
    private final String fileName;
    private final PartitionStorable<P> partitionStorable;
    private final Settings settings;
    private final String allPartitionsHeader;
    private final String completedPartitionsHeader;

    private String allPartitionsHeader() {
        return this.allPartitionsHeader;
    }

    private String completedPartitionsHeader() {
        return this.completedPartitionsHeader;
    }

    @Override
    public void writePartitions(Seq<P> ps) {
        Configuration hBaseConfiguration = this.createHBaseConfiguration();
        HdfsFileUtils$.MODULE$.saveDataToHdfs(this.fileName, hBaseConfiguration, (Function1 & Serializable)os -> {
            HDFSProgressSaver.$anonfun$writePartitions$1(this, ps, os);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public void writeProgress(P p) {
        Configuration hBaseConfiguration = this.createHBaseConfiguration();
        HdfsFileUtils$.MODULE$.appendDataToHdfs(this.fileName, hBaseConfiguration, (Function1 & Serializable)os -> {
            os.writeBytes(new StringBuilder(1).append(this.partitionStorable.asString(p)).append("\n").toString());
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public Seq<P> readPartitions() {
        Configuration hBaseConfiguration = this.createHBaseConfiguration();
        if (HdfsFileUtils$.MODULE$.isFileExists(this.fileName, hBaseConfiguration)) {
            List lines = (List)HdfsFileUtils$.MODULE$.readDataFromHdfs(this.fileName, hBaseConfiguration, (Function1 & Serializable)is -> (List)Using$.MODULE$.resource((Object)Source$.MODULE$.fromInputStream((InputStream)is, Codec$.MODULE$.fallbackSystemCodec()), (Function1 & Serializable)s -> s.getLines().toList(), (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$));
            if (!lines.headOption().contains((Object)this.allPartitionsHeader())) {
                throw new IllegalArgumentException("Incorrect format of partitions file");
            }
            Tuple2 tuple2 = ((List)lines.tail()).span((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)HDFSProgressSaver.$anonfun$readPartitions$3(this, x$1)));
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            List allPartitions = (List)tuple2._1();
            List tail = (List)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)allPartitions, (Object)tail);
            List allPartitions2 = (List)tuple22._1();
            List tail2 = (List)tuple22._2();
            Set donePartitions = tail2.drop(1).toSet();
            List remains = ((List)allPartitions2.filterNot((Function1 & Serializable)p -> BoxesRunTime.boxToBoolean((boolean)donePartitions.contains((Object)p))).zipWithIndex()).map((Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    String line = (String)tuple2._1();
                    int index = tuple2._2$mcI$sp();
                    return $this.partitionStorable.fromString(line, index);
                }
                throw new MatchError((Object)tuple2);
            });
            return remains;
        }
        return (Seq)package$.MODULE$.Seq().empty();
    }

    private Configuration createHBaseConfiguration() {
        Configuration hBaseConfiguration = HBaseConfiguration.create();
        hBaseConfiguration.set("hbase.zookeeper.quorum", (String)this.settings.apply("hbase.zookeeper", Read$.MODULE$.stringRead()));
        hBaseConfiguration.set("zookeeper.session.timeout", "180000");
        HdfsFileUtils$.MODULE$.addHdfsPathToConfiguration(hBaseConfiguration, this.settings);
        return hBaseConfiguration;
    }

    public static final /* synthetic */ void $anonfun$writePartitions$1(HDFSProgressSaver $this, Seq ps$1, DataOutputStream os) {
        os.writeBytes(new StringBuilder(1).append($this.allPartitionsHeader()).append("\n").toString());
        ps$1.foreach((Function1 & Serializable)partition -> {
            os.writeBytes(new StringBuilder(1).append($this.partitionStorable.asString(partition)).append("\n").toString());
            return BoxedUnit.UNIT;
        });
        os.writeBytes(new StringBuilder(1).append($this.completedPartitionsHeader()).append("\n").toString());
    }

    public static final /* synthetic */ boolean $anonfun$readPartitions$3(HDFSProgressSaver $this, String x$1) {
        String string = x$1;
        String string2 = $this.completedPartitionsHeader();
        return string == null ? string2 != null : !string.equals(string2);
    }

    public HDFSProgressSaver(String fileName, PartitionStorable<P> partitionStorable, Settings settings) {
        this.fileName = fileName;
        this.partitionStorable = partitionStorable;
        this.settings = settings;
        this.allPartitionsHeader = "** All Partitions **";
        this.completedPartitionsHeader = "** Completed partitions **";
    }
}

