/*
 * Decompiled with CFR 0.152.
 */
package org.yupana.spark;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import java.io.Serializable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.spark.SparkContext;
import org.yupana.api.query.Query;
import org.yupana.api.schema.Schema;
import org.yupana.core.dao.TsdbQueryMetricsDao;
import org.yupana.core.utils.metric.MetricQueryCollector;
import org.yupana.hbase.HdfsFileUtils$;
import org.yupana.hbase.TsdbQueryMetricsDaoHBase;
import org.yupana.settings.Settings;
import org.yupana.spark.Config;
import org.yupana.spark.SparkMetricCollector;
import org.yupana.spark.SparkMetricsReporter;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.runtime.BoxedUnit;
import scala.runtime.ModuleSerializationProxy;

public final class TsdbSparkBase$
implements StrictLogging,
Serializable {
    public static final TsdbSparkBase$ MODULE$ = new TsdbSparkBase$();
    private static transient Option<TsdbQueryMetricsDao> metricsDao;
    private static Logger logger;

    static {
        StrictLogging.$init$((StrictLogging)MODULE$);
        metricsDao = None$.MODULE$;
    }

    public Logger logger() {
        return logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        logger = x$1;
    }

    public Function1<Query, MetricQueryCollector> $lessinit$greater$default$5(SparkContext sparkContext, Function1<Query, Query> prepareQuery, Config conf, Schema schema) {
        return this.createDefaultMetricCollector(conf, this.createDefaultMetricCollector$default$2());
    }

    public Option<TsdbQueryMetricsDao> metricsDao() {
        return metricsDao;
    }

    public void metricsDao_$eq(Option<TsdbQueryMetricsDao> x$1) {
        metricsDao = x$1;
    }

    public Configuration hbaseConfiguration(Config config) {
        Configuration configuration;
        block0: {
            configuration = new Configuration();
            configuration.set("hbase.zookeeper.quorum", config.hbaseZookeeper());
            configuration.set("hbase.client.scanner.timeout.period", Integer.toString(config.hbaseTimeout()));
            if (!config.addHdfsToConfiguration()) break block0;
            HdfsFileUtils$.MODULE$.addHdfsPathToConfiguration(configuration, (Settings)config.settings());
        }
        return configuration;
    }

    public TsdbQueryMetricsDao getMetricsDao(Config config) {
        Option<TsdbQueryMetricsDao> option = this.metricsDao();
        if (None$.MODULE$.equals(option)) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("TsdbQueryMetricsDao initialization...");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            Connection hbaseConnection = ConnectionFactory.createConnection((Configuration)this.hbaseConfiguration(config));
            TsdbQueryMetricsDaoHBase dao = new TsdbQueryMetricsDaoHBase(hbaseConnection, config.hbaseNamespace());
            this.metricsDao_$eq((Option<TsdbQueryMetricsDao>)new Some((Object)dao));
            return dao;
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            TsdbQueryMetricsDao d = (TsdbQueryMetricsDao)some.value();
            return d;
        }
        throw new MatchError(option);
    }

    private Function1<Query, MetricQueryCollector> createDefaultMetricCollector(Config config, String opName) {
        return (Function1 & Serializable)query -> new SparkMetricCollector((Query)query, opName, config.metricsUpdateInterval(), new SparkMetricsReporter((Function0<TsdbQueryMetricsDao>)(Function0 & Serializable)() -> MODULE$.getMetricsDao(config)));
    }

    private String createDefaultMetricCollector$default$2() {
        return "query";
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(TsdbSparkBase$.class);
    }

    private TsdbSparkBase$() {
    }
}

