/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.fauxpas;

import javax.annotation.Nullable;
import org.apiguardian.api.API;
import org.zalando.fauxpas.ThrowingBiConsumer;
import org.zalando.fauxpas.ThrowingBiFunction;
import org.zalando.fauxpas.ThrowingConsumer;
import org.zalando.fauxpas.ThrowingFunction;

public final class TryWith {
    TryWith() {
    }

    @API(status=API.Status.MAINTAINED)
    public static <O extends AutoCloseable, I extends AutoCloseable, X extends Throwable> void tryWith(@Nullable O outer, @Nullable I inner, ThrowingBiConsumer<O, I, X> consumer) throws X {
        TryWith.tryWith(outer, (R a) -> TryWith.tryWith(inner, (R b) -> consumer.tryAccept(a, b)));
    }

    @API(status=API.Status.STABLE)
    public static <R extends AutoCloseable, X extends Throwable> void tryWith(@Nullable R resource, ThrowingConsumer<R, X> consumer) throws X {
        try {
            consumer.tryAccept(resource);
        }
        catch (Throwable e) {
            throw TryWith.tryClose(resource, TryWith.cast(e));
        }
        TryWith.tryClose(resource);
    }

    @API(status=API.Status.MAINTAINED)
    public static <O extends AutoCloseable, I extends AutoCloseable, T, X extends Throwable> T tryWith(@Nullable O outer, @Nullable I inner, ThrowingBiFunction<O, I, T, X> function) throws X {
        return (T)TryWith.tryWith(outer, (R a) -> TryWith.tryWith(inner, (R b) -> function.tryApply(a, b)));
    }

    @API(status=API.Status.STABLE)
    public static <R extends AutoCloseable, T, X extends Throwable> T tryWith(@Nullable R resource, ThrowingFunction<R, T, X> supplier) throws X {
        T value;
        try {
            value = supplier.tryApply(resource);
        }
        catch (Throwable e) {
            throw TryWith.tryClose(resource, TryWith.cast(e));
        }
        TryWith.tryClose(resource);
        return value;
    }

    private static void tryClose(@Nullable AutoCloseable resource) {
        if (resource == null) {
            return;
        }
        resource.close();
    }

    private static <X extends Throwable> X cast(Throwable e) {
        return (X)e;
    }

    private static <X extends Throwable> X tryClose(@Nullable AutoCloseable closeable, X e) {
        if (closeable == null) {
            return e;
        }
        try {
            closeable.close();
        }
        catch (Throwable inner) {
            e.addSuppressed(inner);
        }
        return e;
    }
}

