/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.log4j2.json;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.time.Instant;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.impl.ThrowableProxy;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.util.ReadOnlyStringMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0013\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0002\u0010\u0006J\"\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\u00022\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u000bH\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/zalando/log4j2/json/LogEventSerializer;", "Lcom/fasterxml/jackson/databind/ser/std/StdSerializer;", "Lorg/apache/logging/log4j/core/LogEvent;", "ignoredPackages", "", "", "(Ljava/util/List;)V", "serialize", "", "value", "generator", "Lcom/fasterxml/jackson/core/JsonGenerator;", "provider", "Lcom/fasterxml/jackson/databind/SerializerProvider;", "serializeThrowable", "proxy", "Lorg/apache/logging/log4j/core/impl/ThrowableProxy;", "log4j2-json-layout"})
public final class LogEventSerializer
extends StdSerializer<LogEvent> {
    private final List<String> ignoredPackages;

    public void serialize(@Nullable LogEvent value, @NotNull JsonGenerator generator, @NotNull SerializerProvider provider) {
        Intrinsics.checkParameterIsNotNull((Object)generator, (String)"generator");
        Intrinsics.checkParameterIsNotNull((Object)provider, (String)"provider");
        if (value == null) {
            generator.writeNull();
            return;
        }
        generator.writeStartObject();
        generator.writeStringField("time", Instant.ofEpochMilli(value.getTimeMillis()).toString());
        generator.writeStringField("severity", value.getLevel().name());
        generator.writeStringField("logger", value.getLoggerName());
        ReadOnlyStringMap readOnlyStringMap = value.getContextData();
        Intrinsics.checkExpressionValueIsNotNull((Object)readOnlyStringMap, (String)"value.contextData");
        if (!readOnlyStringMap.isEmpty()) {
            generator.writeObjectField("context", (Object)value.getContextData());
        }
        Message message = value.getMessage();
        Intrinsics.checkExpressionValueIsNotNull((Object)message, (String)"value.message");
        generator.writeStringField("message", message.getFormattedMessage());
        ThrowableProxy throwableProxy = value.getThrownProxy();
        if (throwableProxy != null) {
            ThrowableProxy throwableProxy2;
            ThrowableProxy it = throwableProxy2 = throwableProxy;
            this.serializeThrowable(it, generator);
        }
        generator.writeStringField("thread", value.getThreadName());
        generator.writeEndObject();
    }

    private final void serializeThrowable(ThrowableProxy proxy, JsonGenerator generator) {
        generator.writeObjectFieldStart("exception");
        Throwable throwable = proxy.getThrowable();
        if (throwable != null) {
            Throwable throwable2;
            Throwable it = throwable2 = throwable;
            generator.writeStringField("thrown", it.getClass().getName());
            String string = it.getMessage();
            if (string != null) {
                String string2;
                String it2 = string2 = string;
                generator.writeStringField("message", it2);
            }
        }
        String trace = proxy.getCauseStackTraceAsString(this.ignoredPackages);
        generator.writeStringField("stack", trace);
        generator.writeEndObject();
    }

    public LogEventSerializer(@NotNull List<String> ignoredPackages) {
        Intrinsics.checkParameterIsNotNull(ignoredPackages, (String)"ignoredPackages");
        super(LogEvent.class);
        this.ignoredPackages = ignoredPackages;
    }
}

