/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.logbook.api;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.zalando.logbook.api.HttpRequest;

public final class RequestURI {
    public static String reconstruct(HttpRequest request) {
        StringBuilder url = new StringBuilder();
        RequestURI.reconstruct(request, url);
        return url.toString();
    }

    public static void reconstruct(HttpRequest request, StringBuilder output) {
        RequestURI.reconstruct(request, EnumSet.allOf(Component.class), output);
    }

    public static String reconstruct(HttpRequest request, Component ... components) {
        StringBuilder url = new StringBuilder();
        RequestURI.reconstruct(request, EnumSet.copyOf(Arrays.asList(components)), url);
        return url.toString();
    }

    public static String reconstruct(HttpRequest request, Set<Component> components) {
        StringBuilder url = new StringBuilder();
        RequestURI.reconstruct(request, components, url);
        return url.toString();
    }

    private static void reconstruct(HttpRequest request, Set<Component> components, StringBuilder url) {
        String scheme = request.getScheme();
        String host = request.getHost();
        Optional<Integer> port = request.getPort();
        String path = request.getPath();
        String query = request.getQuery();
        if (components.contains((Object)Component.SCHEME)) {
            url.append(scheme).append(':');
        }
        if (components.contains((Object)Component.AUTHORITY)) {
            url.append("//").append(host);
            port.ifPresent(p -> {
                if (RequestURI.isNotStandardPort(scheme, p)) {
                    url.append(':').append(p);
                }
            });
        } else if (components.contains((Object)Component.SCHEME)) {
            url.append("//");
        }
        if (components.contains((Object)Component.PATH)) {
            url.append(path);
        } else {
            url.append('/');
        }
        if (components.contains((Object)Component.QUERY) && !query.isEmpty()) {
            url.append('?').append(query);
        }
    }

    private static boolean isNotStandardPort(String scheme, int port) {
        return "http".equals(scheme) && port != 80 || "https".equals(scheme) && port != 443;
    }

    @Generated
    private RequestURI() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static enum Component {
        SCHEME,
        AUTHORITY,
        PATH,
        QUERY;

    }
}

