/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.logbook;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import lombok.Generated;
import org.zalando.logbook.ApplyHttpHeaders;
import org.zalando.logbook.DeleteHttpHeaders;
import org.zalando.logbook.HttpHeaders;
import org.zalando.logbook.UpdateHttpHeaders;

final class DefaultHttpHeaders
extends AbstractMap<String, List<String>>
implements UpdateHttpHeaders,
ApplyHttpHeaders,
DeleteHttpHeaders {
    static final HttpHeaders EMPTY = new DefaultHttpHeaders();
    private final TreeMap<String, List<String>> headers;

    private DefaultHttpHeaders() {
        this(new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER));
    }

    private Map<String, List<String>> delegate() {
        return this.headers;
    }

    @Override
    public HttpHeaders update(String name, Collection<String> values) {
        TreeMap<String, List<String>> updatedHeaders = DefaultHttpHeaders.associate(this.headers, name, values);
        return this.withHeaders(updatedHeaders);
    }

    @Override
    public HttpHeaders delete(Collection<String> names) {
        return this.withHeaders(DefaultHttpHeaders.delete(this.headers, names));
    }

    private static List<String> immutableCopy(Collection<String> values) {
        return Collections.unmodifiableList(new ArrayList<String>(values));
    }

    private static TreeMap<String, List<String>> associate(TreeMap<String, List<String>> original, String key, Collection<String> value) {
        if (Objects.equals(original.get(key), value)) {
            return original;
        }
        TreeMap<String, List<String>> tmpMap = new TreeMap<String, List<String>>((SortedMap<String, List<String>>)original);
        tmpMap.put(key, DefaultHttpHeaders.immutableCopy(value));
        return tmpMap;
    }

    private static TreeMap<String, List<String>> delete(TreeMap<String, List<String>> original, Collection<String> keys) {
        if (Collections.disjoint(original.keySet(), keys)) {
            return original;
        }
        TreeMap<String, List<String>> modifiedMap = new TreeMap<String, List<String>>((SortedMap<String, List<String>>)original);
        keys.forEach(modifiedMap::remove);
        return modifiedMap;
    }

    @Generated
    private DefaultHttpHeaders(TreeMap<String, List<String>> headers) {
        this.headers = headers;
    }

    @Generated
    public DefaultHttpHeaders withHeaders(TreeMap<String, List<String>> headers) {
        return this.headers == headers ? this : new DefaultHttpHeaders(headers);
    }

    @Override
    @Generated
    public int size() {
        return this.delegate().size();
    }

    @Override
    @Generated
    public boolean isEmpty() {
        return this.delegate().isEmpty();
    }

    @Override
    @Generated
    public boolean containsKey(Object arg0) {
        return this.delegate().containsKey(arg0);
    }

    @Override
    @Generated
    public boolean containsValue(Object arg0) {
        return this.delegate().containsValue(arg0);
    }

    @Override
    @Generated
    public List<String> get(Object arg0) {
        return this.delegate().get(arg0);
    }

    @Override
    @Generated
    public List<String> put(String arg0, List<String> arg1) {
        return this.delegate().put(arg0, arg1);
    }

    @Override
    @Generated
    public List<String> remove(Object arg0) {
        return this.delegate().remove(arg0);
    }

    @Override
    @Generated
    public void putAll(Map<? extends String, ? extends List<String>> arg0) {
        this.delegate().putAll(arg0);
    }

    @Override
    @Generated
    public void clear() {
        this.delegate().clear();
    }

    @Override
    @Generated
    public Set<String> keySet() {
        return this.delegate().keySet();
    }

    @Override
    @Generated
    public Collection<List<String>> values() {
        return this.delegate().values();
    }

    @Override
    @Generated
    public Set<Map.Entry<String, List<String>>> entrySet() {
        return this.delegate().entrySet();
    }

    @Override
    @Generated
    public List<String> getOrDefault(Object key, List<String> defaultValue) {
        return this.delegate().getOrDefault(key, defaultValue);
    }

    @Override
    @Generated
    public void forEach(BiConsumer<? super String, ? super List<String>> action) {
        this.delegate().forEach(action);
    }

    @Override
    @Generated
    public void replaceAll(BiFunction<? super String, ? super List<String>, ? extends List<String>> function) {
        this.delegate().replaceAll(function);
    }

    @Override
    @Generated
    public List<String> putIfAbsent(String key, List<String> value) {
        return this.delegate().putIfAbsent(key, value);
    }

    @Override
    @Generated
    public boolean remove(Object key, Object value) {
        return this.delegate().remove(key, value);
    }

    @Override
    @Generated
    public boolean replace(String key, List<String> oldValue, List<String> newValue) {
        return this.delegate().replace(key, oldValue, newValue);
    }

    @Override
    @Generated
    public List<String> replace(String key, List<String> value) {
        return this.delegate().replace(key, value);
    }

    @Override
    @Generated
    public List<String> computeIfAbsent(String key, Function<? super String, ? extends List<String>> mappingFunction) {
        return this.delegate().computeIfAbsent(key, mappingFunction);
    }

    @Override
    @Generated
    public List<String> computeIfPresent(String key, BiFunction<? super String, ? super List<String>, ? extends List<String>> remappingFunction) {
        return this.delegate().computeIfPresent(key, remappingFunction);
    }

    @Override
    @Generated
    public List<String> compute(String key, BiFunction<? super String, ? super List<String>, ? extends List<String>> remappingFunction) {
        return this.delegate().compute(key, remappingFunction);
    }

    @Override
    @Generated
    public List<String> merge(String key, List<String> value, BiFunction<? super List<String>, ? super List<String>, ? extends List<String>> remappingFunction) {
        return this.delegate().merge(key, value, remappingFunction);
    }
}

