/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.logbook.httpclient;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.util.EntityUtils;
import org.zalando.logbook.BaseHttpMessage;
import org.zalando.logbook.HttpResponse;
import org.zalando.logbook.Origin;
import org.zalando.logbook.RawHttpResponse;

final class RemoteResponse
implements RawHttpResponse,
HttpResponse {
    private final org.apache.http.HttpResponse response;
    private byte[] body;

    RemoteResponse(org.apache.http.HttpResponse response) {
        this.response = response;
    }

    public Origin getOrigin() {
        return Origin.REMOTE;
    }

    public String getProtocolVersion() {
        return this.response.getStatusLine().getProtocolVersion().toString();
    }

    public int getStatus() {
        return this.response.getStatusLine().getStatusCode();
    }

    public Map<String, List<String>> getHeaders() {
        BaseHttpMessage.HeadersBuilder builder = new BaseHttpMessage.HeadersBuilder();
        for (Header header : this.response.getAllHeaders()) {
            builder.put(header.getName(), header.getValue());
        }
        return builder.build();
    }

    public String getContentType() {
        return Optional.of(this.response).map(request -> request.getFirstHeader("Content-Type")).map(NameValuePair::getValue).orElse("");
    }

    public Charset getCharset() {
        return Optional.of(this.response).map(request -> request.getFirstHeader("Content-Type")).map(NameValuePair::getValue).map(ContentType::parse).map(ContentType::getCharset).orElse(StandardCharsets.UTF_8);
    }

    public byte[] getBody() {
        return this.body;
    }

    public HttpResponse withBody() throws IOException {
        HttpEntity originalEntity = this.response.getEntity();
        if (originalEntity == null) {
            this.body = new byte[0];
            return this;
        }
        this.body = EntityUtils.toByteArray((HttpEntity)originalEntity);
        ByteArrayEntity byteArrayEntity = new ByteArrayEntity(this.body);
        byteArrayEntity.setChunked(originalEntity.isChunked());
        byteArrayEntity.setContentEncoding(originalEntity.getContentEncoding());
        byteArrayEntity.setContentType(originalEntity.getContentType());
        this.response.setEntity((HttpEntity)byteArrayEntity);
        return this;
    }
}

