/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.logbook.httpclient;

import java.io.IOException;
import java.util.Optional;
import java.util.function.Consumer;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.protocol.HttpContext;
import org.apiguardian.api.API;
import org.zalando.logbook.Correlator;
import org.zalando.logbook.Logbook;
import org.zalando.logbook.RawHttpRequest;
import org.zalando.logbook.httpclient.Attributes;
import org.zalando.logbook.httpclient.LocalRequest;

@API(status=API.Status.STABLE)
public final class LogbookHttpRequestInterceptor
implements HttpRequestInterceptor {
    private final Logbook logbook;

    public LogbookHttpRequestInterceptor(Logbook logbook) {
        this.logbook = logbook;
    }

    public void process(HttpRequest httpRequest, HttpContext context) throws HttpException, IOException {
        LocalRequest request = new LocalRequest(httpRequest);
        Optional correlator = this.logbook.write((RawHttpRequest)request);
        correlator.ifPresent(this.writeCorrelator(context));
    }

    private Consumer<Correlator> writeCorrelator(HttpContext context) {
        return correlator -> context.setAttribute(Attributes.CORRELATOR, correlator);
    }
}

