/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.logbook.httpclient;

import java.io.IOException;
import java.util.Optional;
import java.util.function.Consumer;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.protocol.HttpContext;
import org.apiguardian.api.API;
import org.zalando.fauxpas.FauxPas;
import org.zalando.logbook.Correlator;
import org.zalando.logbook.RawHttpResponse;
import org.zalando.logbook.httpclient.Attributes;
import org.zalando.logbook.httpclient.RemoteResponse;

@API(status=API.Status.STABLE)
public final class LogbookHttpResponseInterceptor
implements HttpResponseInterceptor {
    public void process(HttpResponse original, HttpContext context) throws IOException {
        Optional<Correlator> correlator = this.findCorrelator(context);
        correlator.ifPresent((Consumer<Correlator>)FauxPas.throwingConsumer(c -> c.write((RawHttpResponse)new RemoteResponse(original))));
    }

    private Optional<Correlator> findCorrelator(HttpContext context) {
        return Optional.ofNullable(context.getAttribute(Attributes.CORRELATOR)).map(Correlator.class::cast);
    }
}

