/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.logbook.httpclient;

import java.io.IOException;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.client.methods.HttpRequestWrapper;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.util.EntityUtils;
import org.zalando.logbook.BaseHttpMessage;
import org.zalando.logbook.HttpRequest;
import org.zalando.logbook.Origin;
import org.zalando.logbook.RawHttpRequest;

final class LocalRequest
implements RawHttpRequest,
HttpRequest {
    private final org.apache.http.HttpRequest request;
    private final URI originalRequestUri;
    private byte[] body;

    LocalRequest(org.apache.http.HttpRequest request) {
        this.request = request;
        this.originalRequestUri = LocalRequest.getOriginalRequestUri(request);
    }

    private static URI getOriginalRequestUri(org.apache.http.HttpRequest request) {
        if (request instanceof HttpRequestWrapper) {
            return LocalRequest.extractRequestUri(((HttpRequestWrapper)HttpRequestWrapper.class.cast(request)).getOriginal());
        }
        if (request instanceof HttpUriRequest) {
            return ((HttpUriRequest)HttpUriRequest.class.cast(request)).getURI();
        }
        return LocalRequest.extractRequestUri(request);
    }

    private static URI extractRequestUri(org.apache.http.HttpRequest request) {
        return URI.create(request.getRequestLine().getUri());
    }

    public Origin getOrigin() {
        return Origin.LOCAL;
    }

    public String getProtocolVersion() {
        return this.request.getRequestLine().getProtocolVersion().toString();
    }

    public String getRemote() {
        return "localhost";
    }

    public String getMethod() {
        return this.request.getRequestLine().getMethod();
    }

    public String getScheme() {
        return this.originalRequestUri.getScheme();
    }

    public String getHost() {
        return this.originalRequestUri.getHost();
    }

    public Optional<Integer> getPort() {
        return Optional.of(this.originalRequestUri.getPort()).filter(p -> p != -1);
    }

    public String getPath() {
        return this.originalRequestUri.getPath();
    }

    public String getQuery() {
        return Optional.ofNullable(this.originalRequestUri.getQuery()).orElse("");
    }

    public Map<String, List<String>> getHeaders() {
        BaseHttpMessage.HeadersBuilder builder = new BaseHttpMessage.HeadersBuilder();
        for (Header header : this.request.getAllHeaders()) {
            builder.put(header.getName(), header.getValue());
        }
        return builder.build();
    }

    public String getContentType() {
        return Optional.of(this.request).map(request -> request.getFirstHeader("Content-Type")).map(Header::getValue).orElse("");
    }

    public Charset getCharset() {
        return Optional.of(this.request).map(request -> request.getFirstHeader("Content-Type")).map(Header::getValue).map(ContentType::parse).map(ContentType::getCharset).orElse(StandardCharsets.UTF_8);
    }

    public byte[] getBody() {
        return this.body;
    }

    public HttpRequest withBody() throws IOException {
        if (this.request instanceof HttpEntityEnclosingRequest) {
            HttpEntityEnclosingRequest request = (HttpEntityEnclosingRequest)this.request;
            this.body = EntityUtils.toByteArray((HttpEntity)request.getEntity());
            request.setEntity((HttpEntity)new ByteArrayEntity(this.body));
        } else {
            this.body = new byte[0];
        }
        return this;
    }
}

